<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('staff', [
    'as'                        => 'staff',
    'middleware'                => ['permissions.required'],
    'module'                    => STAFF_LIST,
    'permissions'               => [LIST_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'StaffController@index'
]);
Route::get('staff/by-station', [
    'as'                        => 'staff',
    'middleware'                => ['permissions.required'],
    'module'                    => STAFF_LIST,
    'permissions'               => [LIST_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'StaffController@byStation'
]);

Route::get('staff/terminated-deleted', [
    'as'                        => 'staff',
    'middleware'                => ['permissions.required'],
    'module'                    => STAFF_LIST,
    'permissions'               => [DELETED_LIST_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'StaffController@terminatedDeleted'
]);

Route::get('staff/{user}/delete', [
    'as'                        => 'staff/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => STAFF_LIST,
    'permissions'               => [DELETE_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'StaffController@delete'
]);

Route::get('staff/{user}/restore', [
    'as'                        => 'staff/restore',
    'middleware'                => ['permissions.required'],
    'module'                    => STAFF_LIST,
    'permissions'               => [DELETE_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'StaffController@restore'
]);

Route::get('staff/{user}/edit', [
    'as'                        => 'staff/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => STAFF_LIST,
    'permissions'               => [EDIT_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'StaffController@edit',

    // SKIP CHECK
    'profile_page'              => true,
]);

Route::get('staff/{user}', [
    'as'                        => 'staff/show',
    'middleware'                => ['permissions.required'],
    'module'                    => STAFF_LIST,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'StaffController@show',
    // SKIP CHECK
    'profile_page'              => true,
]);

Route::post('staff/{user}', [
    'as'                        => 'staff/update',
    'middleware'                => ['permissions.required'],
    'module'                    => STAFF_LIST,
//    'permissions'               => [EDIT_PERMISSION],
//    'permissions_require_all'   => true,
    'uses'                      => 'StaffController@update'
]);
