<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('staff-license/delete/{staff_license}', [
    'as'                        => 'staff-license/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => STAFF_LICENSES,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'StaffLicenseController@delete'
]);

Route::get('staff-license/delete/file/{staff_license}', [
    'as'                        => 'staff-license/delete-file',
    'middleware'                => ['permissions.required'],
    'module'                    => STAFF_LICENSES,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'StaffLicenseController@deleteFile'
]);

Route::get('staff-license/create/{user}', [
    'as'                        => 'staff-license/create',
    'middleware'                => ['permissions.required'],
    'module'                    => STAFF_LICENSES,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'StaffLicenseController@create'
]);

Route::get('staff-license/{staff_license}', [
    'as'                        => 'staff-license/show',
    'middleware'                => ['permissions.required'],
    'module'                    => STAFF_LICENSES,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'StaffLicenseController@show'
]);

Route::post('staff-license/{staff_license}', [
    'as'                        => 'staff-license/store',
    'middleware'                => ['permissions.required'],
    'module'                    => STAFF_LICENSES,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'StaffLicenseController@store'
]);

Route::post('staff-license/update-store/{user}', [
    'as'                        => 'staff-license/update-store',
    'middleware'                => ['permissions.required'],
    'module'                    => STAFF_LICENSES,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'StaffLicenseController@updateStore'
]);

