<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('service', [
    'as'                        => 'service',
    'middleware'                => ['permissions.required'],
    'module'                    => SERVICES,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'ServiceController@index'
]);

Route::post('service', [
    'as'                        => 'service/store',
    'middleware'                => ['permissions.required'],
    'module'                    => SERVICES,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'ServiceController@store'
]);

Route::post('service/{service}', [
    'as'                        => 'service/update',
    'middleware'                => ['permissions.required'],
    'module'                    => SERVICES,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'ServiceController@update'
]);

Route::delete('service/{service}', [
    'as'                        => 'service/destroy',
    'middleware'                => ['permissions.required'],
    'module'                    => SERVICES,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'ServiceController@destroy'
]);


Route::get('service/{service}/edit', [
    'as'                        => 'service/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => SERVICES,
    'permissions'               => [EDIT_PERMISSION],
//    'user_roles'                => [ADMIN, SUPER_ADMIN],
    'uses'                      => 'ServiceController@edit'
]);

Route::get('service/create', [
    'as'                        => 'service/create',
    'middleware'                => ['permissions.required'],
    'module'                    => SERVICES,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'ServiceController@create'
]);

Route::get('service/{service}', [
    'as'                        => 'service/show',
    'middleware'                => ['permissions.required'],
    'module'                    => SERVICES,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'ServiceController@show'
]);

Route::get('service/{service}/delete', [
    'as'                        => 'service/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => SERVICES,
    'permissions'               => [DELETE_PERMISSION],
    'user_roles'                => [ADMIN, SUPER_ADMIN],
    'uses'                      => 'ServiceController@destroy'
]);
