<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('scm-report', [
    'as'                        => 'scm-report',
    'middleware'                => ['permissions.required'],
    'module'                    => SCM_REPORT,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'SCMController@index'
]);

Route::get('scm-report/create', [
    'as'                        => 'scm-report/create',
    'middleware'                => ['permissions.required'],
    'module'                    => SCM_REPORT,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'SCMController@create'
]);

Route::get('scm-report/delete/{scm}', [
    'as'                        => 'scm-report/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => SCM_REPORT,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'SCMController@delete'
]);

Route::get('scm-report/restore/{scm}', [
    'as'                        => 'scm-report/restore',
    'middleware'                => ['permissions.required'],
    'module'                    => SCM_REPORT,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'SCMController@restore'
]);

Route::post('scm-report',      ['as' => 'scm-report/store',       'uses' => 'SCMController@store']);

Route::get('scm-report/{container}', [
    'as'                        => 'scm-report/show',
    'middleware'                => ['permissions.required'],
    'module'                    => SCM_REPORT,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'SCMController@show'
]);

