<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */


Route::get('revenue-target',                        [
    'as' => 'revenue-target/index',
    'middleware'                => ['permissions.required'],
    'module'                    => REVENUE_TARGET,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses' => 'RevenueTargetController@index'
]);

Route::get('revenue-target/create',                 [
    'as' => 'revenue-target/create',
    'middleware'                => ['permissions.required'],
    'module'                    => REVENUE_TARGET,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses' => 'RevenueTargetController@create'
]);

Route::get('revenue-target/removed-list',           [
    'as' => 'revenue-target/removed-list',
    'middleware'                => ['permissions.required'],
    'module'                    => REVENUE_TARGET,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses' => 'RevenueTargetController@removedList'
]);

Route::put('revenue-target/{id}/restore',           [
    'as' => 'revenue-target/restore',
    'middleware'                => ['permissions.required'],
    'module'                    => REVENUE_TARGET,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses' => 'RevenueTargetController@restore'
]);

Route::delete('revenue-target/{revenue_target}',    [
    'as' => 'revenue-target/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => REVENUE_TARGET,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses' => 'RevenueTargetController@destroy'
]);

Route::post('revenue-target',                       [
    'as' => 'revenue-target/store',
    'middleware'                => ['permissions.required'],
    'module'                    => REVENUE_TARGET,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses' => 'RevenueTargetController@store'
]);

Route::get('revenue-target/{revenue_target}',       [
    'as' => 'revenue-target/show',
    'middleware'                => ['permissions.required'],
    'module'                    => REVENUE_TARGET,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses' => 'RevenueTargetController@show'
]);

Route::get('revenue-target/{revenue_target}/edit',  [
    'as' => 'revenue-target/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => REVENUE_TARGET,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses' => 'RevenueTargetController@edit'
]);

Route::put('revenue-target/{revenue_target}',       [
    'as' => 'revenue-target/update',
    'middleware'                => ['permissions.required'],
    'module'                    => REVENUE_TARGET,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses' => 'RevenueTargetController@update'
]);
