<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('revenue-target-period',                                 [
    'as' => 'revenue-target-period/index',
    'middleware'                => ['permissions.required'],
    'module'                    => REVENUE_TARGET_PERIODS,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses' => 'RevenueTargetPeriodController@index'
]);

Route::get('revenue-target-period/create',                          [
    'as' => 'revenue-target-period/create',
    'middleware'                => ['permissions.required'],
    'module'                    => REVENUE_TARGET_PERIODS,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses' => 'RevenueTargetPeriodController@create'
]);

Route::delete('revenue-target-period/{revenue_target_period}',      [
    'as' => 'revenue-target-period/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => REVENUE_TARGET_PERIODS,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses' => 'RevenueTargetPeriodController@destroy'
]);

Route::post('revenue-target-period',                                [
    'as' => 'revenue-target-period/store',
    'middleware'                => ['permissions.required'],
    'module'                    => REVENUE_TARGET_PERIODS,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses' => 'RevenueTargetPeriodController@store'
]);

Route::get('revenue-target-period/{revenue_target_period}',         [
    'as' => 'revenue-target-period/show',
    'middleware'                => ['permissions.required'],
    'module'                    => REVENUE_TARGET_PERIODS,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses' => 'RevenueTargetPeriodController@show'
]);

Route::get('revenue-target-period/{revenue_target_period}/edit',    [
    'as' => 'revenue-target-period/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => REVENUE_TARGET_PERIODS,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses' => 'RevenueTargetPeriodController@edit'
]);

Route::put('revenue-target-period/{revenue_target_period}',         [
    'as' => 'revenue-target-period/update',
    'middleware'                => ['permissions.required'],
    'module'                    => REVENUE_TARGET_PERIODS,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses' => 'RevenueTargetPeriodController@update'
]);
