<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get("position/ajax-positions",   "PositionController@getAjaxPositions");
Route::get("position/ajax-position-users",   "PositionController@getAjaxPositionUsers");

Route::get('position/index', [
    'as'                        => 'position/index',
    'middleware'                => ['permissions.required'],
    'module'                    => DEPARTMENTS,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'PositionController@getIndex'
]);

Route::get('position', [
    'as'                        => 'position',
    'middleware'                => ['permissions.required'],
    'module'                    => DEPARTMENTS,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'PositionController@getIndex'
]);

Route::get('position/delete', [
    'as'                        => 'position/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => DEPARTMENTS,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'PositionController@getDelete'
]);

Route::get('position/create', [
    'as'                        => 'position/create',
    'middleware'                => ['permissions.required'],
    'module'                    => DEPARTMENTS,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'PositionController@create'
]);

Route::post('position', [
    'as'                        => 'position/store',
    'middleware'                => ['permissions.required'],
    'module'                    => DEPARTMENTS,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'PositionController@store'
]);

Route::get('position/{position}/edit', [
    'as'                        => 'position/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => DEPARTMENTS,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'PositionController@edit'
]);

Route::post('position/{position}', [
    'as'                        => 'position/update',
    'middleware'                => ['permissions.required'],
    'module'                    => DEPARTMENTS,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'PositionController@update'
]);

