<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */


Route::get('organization-level',            ['as' => 'organization/index',              'uses' => 'OrganizationLevelController@index']);
Route::get('organization-level/create',     ['as' => 'organization-level/create',       'uses' => 'OrganizationLevelController@create']);
Route::post('organization-level',           ['as' => 'organization-level/store',        'uses' => 'OrganizationLevelController@store']);
Route::get('organization-level/{id}/edit',  ['as' => 'organization-level/edit',         'uses' => 'OrganizationLevelController@edit']);
Route::post('organization-level/{id}',      ['as' => 'organization-level/update',       'uses' => 'OrganizationLevelController@update']);
Route::delete('organization-level/{id}',    ['as' => 'organization-level/delete',       'uses' => 'OrganizationLevelController@delete']);


Route::get('organization', [
    'as'                        => 'organization/index',
    'middleware'                => ['permissions.required'],
    'module'                    => ORGANISATION,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'OrganizationController@index'
]);

Route::get('organization/create', [
    'as'                        => 'organization/create',
    'middleware'                => ['permissions.required'],
    'module'                    => ORGANISATION,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'OrganizationController@create'
]);

Route::get('organization/{organization}/edit', [
    'as'                        => 'organization/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => ORGANISATION,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'OrganizationController@edit'
]);

Route::post('organization',                      ['as' => 'organization/store',       'uses' => 'OrganizationController@store']);
Route::post('organization/{organization}',       ['as' => 'organization/update',      'uses' => 'OrganizationController@update']);
Route::delete('organization/{organization}',       ['as' => 'organization/delete',      'uses' => 'OrganizationController@delete']);


Route::get('organization/chart', [
    'as'                        => 'organization/chart',
    'middleware'                => ['permissions.required'],
    'module'                    => ORGANISATION,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'OrganizationController@chart'
]);

Route::get('organization/chart/{organization}', [
    'as'                        => 'organization/chart/organization',
    'middleware'                => ['permissions.required'],
    'module'                    => ORGANISATION,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'OrganizationController@chartOrganization'
]);


Route::get('organization/chart/department/{department}', [
    'as'                        => 'organization/chart/department',
    'middleware'                => ['permissions.required'],
    'module'                    => ORGANISATION,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'OrganizationController@chartDepartment'
]);

Route::get('organization/new-chart/department/{department}', [
    'as'                        => 'organization/new-chart/department',
    'middleware'                => ['permissions.required'],
    'module'                    => ORGANISATION,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'OrganizationController@newChartDepartment'
]);

Route::get('organization/new-chart/user/{user}', [
    'as'                        => 'organization/new-chart/organization/user',
    'middleware'                => ['permissions.required'],
    'module'                    => ORGANISATION,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'OrganizationController@newChartOrganizationByUserId'
]);


Route::get('organization/new-chart/{organization}', [
    'as'                        => 'organization/new-chart/organization',
    'middleware'                => ['permissions.required'],
    'module'                    => ORGANISATION,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'OrganizationController@newChartOrganization'
]);

Route::get('organization/chart/{organization}', [
    'as'                        => 'organization/chart/organization',
    'middleware'                => ['permissions.required'],
    'module'                    => ORGANISATION,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'OrganizationController@chartOrganization'
]);
