<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('notification', [
    'as'                        => 'notification/index',
    'middleware'                => ['permissions.required'],
    'module'                    => EMAIL_NOTIFICATION,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'NotificationController@index'
]);

Route::post('notification', [
    'as'                        => 'notification/store',
    'middleware'                => ['permissions.required'],
    'module'                    => EMAIL_NOTIFICATION,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'NotificationController@store'
]);

Route::get('notification/{notification}/edit', [
    'as'                        => 'notification/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => EMAIL_NOTIFICATION,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'NotificationController@edit'
]);

Route::post('notification/{notification}', [
    'as'                        => 'notification/update',
    'middleware'                => ['permissions.required'],
    'module'                    => EMAIL_NOTIFICATION,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'NotificationController@update'
]);

Route::get('notification/create', [
    'as'                        => 'notification/create',
    'middleware'                => ['permissions.required'],
    'module'                    => EMAIL_NOTIFICATION,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'NotificationController@create'
]);

Route::get('notification/{notification}', [
    'as'                        => 'notification/show',
    'middleware'                => ['permissions.required'],
    'module'                    => EMAIL_NOTIFICATION,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'NotificationController@show'
]);

Route::get('notification/{notification}/delete', [
    'as'                        => 'notification/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => EMAIL_NOTIFICATION,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'NotificationController@delete'
]);

