<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('module', [
    'as'                        => 'module/index',
    'middleware'                => ['permissions.required'],
    'module'                    => MODULES,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [SUPER_ADMIN],
    'uses'                      => 'ModuleController@index'
]);

Route::post('module', [
    'as'                        => 'module/store',
    'middleware'                => ['permissions.required'],
    'module'                    => MODULES,
    'permissions'               => [CREATE_PERMISSION],
    'user_roles'                => [SUPER_ADMIN],
    'uses'                      => 'ModuleController@store'
]);


Route::post('module/ajax-save-permission',           ['as' => 'module/ajax-save-permission',            'uses' => 'ModuleController@ajaxSavePermission']);
Route::post('module/ajax-delete-permission',         ['as' => 'module/ajax-delete-permission',          'uses' => 'ModuleController@ajaxDeletePermission']);
Route::post('module/ajax-restore-permission',        ['as' => 'module/ajax-restore-permission',         'uses' => 'ModuleController@ajaxRestorePermission']);
Route::post('module/ajax-update-module-department',  ['as' => 'module/ajax-update-module-department',   'uses' => 'ModuleController@ajaxUpdateModuleDepartment']);

Route::post('module/{module}', [
    'as'                        => 'module/update',
    'middleware'                => ['permissions.required'],
    'module'                    => MODULES,
    'permissions'               => [EDIT_PERMISSION],
    'user_roles'                => [SUPER_ADMIN],
    'uses'                      => 'ModuleController@update'
]);

Route::get('module/delete/{module}', [
    'as'                        => 'module/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => MODULES,
    'permissions'               => [DELETE_PERMISSION],
    'user_roles'                => [SUPER_ADMIN],
    'uses'                      => 'ModuleController@delete'
]);

Route::get('module/{module}/edit', [
    'as'                        => 'module/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => MODULES,
    'permissions'               => [VIEW_PERMISSION],
    'user_roles'                => [SUPER_ADMIN],
    'uses'                      => 'ModuleController@edit'
]);

Route::get('module/create', [
    'as'                        => 'module/create',
    'middleware'                => ['permissions.required'],
    'module'                    => MODULES,
    'permissions'               => [CREATE_PERMISSION],
    'user_roles'                => [SUPER_ADMIN],
    'uses'                      => 'ModuleController@create'
]);


Route::get('module/users', [
    'as'                        => 'module/users',
    'middleware'                => ['permissions.required'],
    'module'                    => MODULES,
    'permissions'               => [EDIT_PERMISSION],
    'user_roles'                => [SUPER_ADMIN],
    'uses'                      => 'ModuleController@users'
]);

Route::get('module/map', [
    'as'                        => 'module/map',
    'middleware'                => ['permissions.required'],
    'module'                    => MODULES,
    'permissions'               => [VIEW_PERMISSION],
    'user_roles'                => [SUPER_ADMIN],
    'uses'                      => 'ModuleController@map'
]);





