<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('license', [
    'as'                        => 'license/index',
    'middleware'                => ['permissions.required'],
    'module'                    => LICENSES_APPROVALS,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'LicenseController@index'
]);

Route::get('license/create', [
    'as'                        => 'license/create',
    'middleware'                => ['permissions.required'],
    'module'                    => LICENSES_APPROVALS,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'LicenseController@create'
]);

Route::get('license/{license}', [
    'as'                        => 'license/show',
    'middleware'                => ['permissions.required'],
    'module'                    => LICENSES_APPROVALS,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'LicenseController@show'
]);

Route::post('license', [
    'as'                        => 'license/store',
    'middleware'                => ['permissions.required'],
    'module'                    => LICENSES_APPROVALS,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'LicenseController@store'
]);

Route::get('license/{license}/edit', [
    'as'                        => 'license/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => LICENSES_APPROVALS,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'LicenseController@edit'
]);

Route::post('license/{license}', [
    'as'                        => 'license/update',
    'middleware'                => ['permissions.required'],
    'module'                    => LICENSES_APPROVALS,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'LicenseController@update'
]);

Route::get('license/{license}/delete', [
    'as'                        => 'license/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => LICENSES_APPROVALS,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'LicenseController@delete'
]);

Route::delete('license/{license}', [
    'as'                        => 'license/destroy',
    'middleware'                => ['permissions.required'],
    'module'                    => LICENSES_APPROVALS,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'LicenseController@destroy'
]);


