<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('library', [
    'as'                        => 'library/index',
    'middleware'                => ['permissions.required'],
    'module'                    => LIBRARY,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'LibraryController@index'
]);

Route::get('library/create', [
    'as'                        => 'library/create',
    'middleware'                => ['permissions.required'],
    'module'                    => LIBRARY,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'LibraryController@create'
]);

Route::post('library', [
    'as'                        => 'library/store',
    'middleware'                => ['permissions.required'],
    'module'                    => LIBRARY,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'LibraryController@store'
]);

Route::get('library/{library}/edit', [
    'as'                        => 'library/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => LIBRARY,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'LibraryController@edit'
]);

Route::post('library/{library}', [
    'as'                        => 'library/update',
    'middleware'                => ['permissions.required'],
    'module'                    => LIBRARY,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'LibraryController@update'
]);


Route::get('library/airline/{airline}', [
    'as'                        => 'library/show-airline',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINE_LIBRARY,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'LibraryController@showAirline'
]);

Route::get('library/{library}', [
    'as'                        => 'library/show',
    'middleware'                => ['permissions.required'],
    'module'                    => LIBRARY,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'LibraryController@show'
]);

Route::get('library/delete/{library}', [
    'as'                        => 'library/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => LIBRARY,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'LibraryController@delete'
]);

Route::get('library/file/{library}', [
    'as'                        => 'library/show-file',
    'middleware'                => ['permissions.required'],
    'module'                    => LIBRARY,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'LibraryController@showFile'
]);

Route::get('library/file/delete/{library}', [
    'as'                        => 'library/delete-file',
    'middleware'                => ['permissions.required'],
    'module'                    => LIBRARY,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'LibraryController@deleteFile'
]);

Route::post('library/file/{library}', [
    'as'                        => 'library/store-file',
    'middleware'                => ['permissions.required'],
    'module'                    => LIBRARY,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'LibraryController@storeFile'
]);

