<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('holiday', [
    'as'                        => 'holiday/index',
    'middleware'                => ['permissions.required'],
    'module'                    => HOLIDAYS,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'HolidayController@index'
]);

Route::get('holiday/create', [
    'as'                        => 'holiday/create',
    'middleware'                => ['permissions.required'],
    'module'                    => HOLIDAYS,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'HolidayController@create'
]);

Route::get('holiday/copy_for_next_year', [
    'as'                        => 'holiday/copy_for_next_year',
    'middleware'                => ['permissions.required'],
    'module'                    => HOLIDAYS,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'HolidayController@copyForNextYear'
]);

Route::post('holiday', [
    'as'                        => 'holiday/store',
    'middleware'                => ['permissions.required'],
    'module'                    => HOLIDAYS,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'HolidayController@store'
]);

Route::get('holiday/{holiday}/edit', [
    'as'                        => 'holiday/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => HOLIDAYS,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'HolidayController@edit'
]);

Route::post('holiday/{holiday}', [
    'as'                        => 'holiday/update',
    'middleware'                => ['permissions.required'],
    'module'                    => HOLIDAYS,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'HolidayController@update'
]);

Route::get('holiday/airport/{airport}', [
    'as'                        => 'holiday/show-airline',
    'middleware'                => ['permissions.required'],
    'module'                    => HOLIDAYS,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'HolidayController@showAirport'
]);

Route::get('holiday/{holiday}', [
    'as'                        => 'holiday/show',
    'middleware'                => ['permissions.required'],
    'module'                    => HOLIDAYS,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'HolidayController@show'
]);

Route::get('holiday/delete/{holiday}', [
    'as'                        => 'holiday/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => HOLIDAYS,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'HolidayController@delete'
]);


