<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */


Route::get('handling-flight-schedule', [
    'as'                        => 'handling-flight-schedule',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_SCHEDULE,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'HandlingFlightScheduleController@index'
]);

Route::get('handling-flight-schedule/create', [
    'as'                        => 'handling-flight-schedule-create',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_SCHEDULE,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'HandlingFlightScheduleController@manualCreate'
]);

Route::get('handling-flight-schedule/destroy/{flight_schedule}', [
    'as'                        => 'handling-flight-schedule-destroy',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_SCHEDULE,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'HandlingFlightScheduleController@destroy'
]);

Route::post('handling-flight-schedule', [
    'as'                        => 'handling-flight-schedule-store',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_SCHEDULE,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'HandlingFlightScheduleController@store'
]);

Route::get('handling-flight-schedule-airlines/{flight_schedule}', [
    'as'                        => 'handling-flight-schedule-airlines',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_SCHEDULE,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'HandlingFlightScheduleController@airlines'
]);

Route::get('handling-flight-schedule-flights/{flight_schedule}', [
    'as'                        => 'handling-flight-schedule-flights',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_SCHEDULE,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'HandlingFlightScheduleController@flights'
]);


Route::post('handling-flight-schedule-flights/restore/{flight_schedule_flight}', [
    'as'                        => 'handling-flight-schedule-flights/restore',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_SCHEDULE,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'HandlingFlightScheduleController@restore'
]);

Route::post('handling-flight-schedule-flights/restore/{flight_schedule_flight}', [
    'as'                        => 'handling-flight-schedule-flights/restore',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_SCHEDULE,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'HandlingFlightScheduleController@restore'
]);

Route::post('handling-flight-schedule-flights/delete/{flight_schedule_flight}', [
    'as'                        => 'handling-flight-schedule-flights/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_SCHEDULE,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'HandlingFlightScheduleController@delete'
]);

Route::post('handling-flight-schedule-flights/delete-selected', [
    'as'                        => 'handling-flight-schedule-flights/delete-selected',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_SCHEDULE,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'HandlingFlightScheduleController@deleteSelected'
]);

Route::post('handling-flight-schedule-flights/restore-selected', [
    'as'                        => 'handling-flight-schedule-flights/restore-selected',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_SCHEDULE,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'HandlingFlightScheduleController@restoreSelected'
]);

Route::post('handling-flight-schedule-flights/create', [
    'as'                        => 'handling-flight-schedule-flights/create',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_SCHEDULE,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'HandlingFlightScheduleController@create'
]);

Route::post('handling-flight-schedule-flights/flights/delete', [
    'as'                        => 'handling-flight-schedule-flights/flights/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_SCHEDULE,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'HandlingFlightScheduleController@deleteFlights'
]);

Route::post('handling-flight-schedule-flights/flights/edit', [
    'as'                        => 'handling-flight-schedule-flights/flights/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_SCHEDULE,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'HandlingFlightScheduleController@editFlights'
]);


