<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('flight-watch', [
    'as'                        => 'flight-watch',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_WATCH,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'FlightWatchController@flightWatch'
]);

Route::get('flight-watch/ajax-get-flight', [
    'as'                        => 'flight-watch/ajax-get-flight',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_WATCH,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'FlightWatchController@ajaxGetFlight',
//    'skip_log'                  => true,
]);

Route::get('flight-watch/ajax-get-flight/{flight}', [
    'as'                        => 'flight-watch/ajax-get-flight',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_WATCH,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'FlightWatchController@ajaxGetFlight',
//    'skip_log'                  => true,
]);

Route::get('flight-watch/ajax-get-flights', [
    'as'                        => 'flight-watch/ajax-get-flights',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_WATCH,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'FlightWatchController@ajaxGetFlights',
    'skip_log'                  => true,
]);

Route::get('flight-watch/ajax-get-range', [
    'as'                        => 'flight-watch/ajax-get-range',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_WATCH,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'FlightWatchController@ajaxGetRange',
    'skip_log'                  => true,
]);

Route::get('flight-watch/ajax-search-airport', [
    'as'                        => 'flight-watch/ajax-search-airport',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_WATCH,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'FlightWatchController@ajaxSearchAirport'
]);

Route::post('flight-watch/mvt-departure', [
    'as'                        => 'flight-watch/mvt-departure',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_WATCH,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'FlightWatchController@ajaxMVTDeparture'
]);

Route::post('flight-watch/mvt-arrival', [
    'as'                        => 'flight-watch/mvt-arrival',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_WATCH,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'FlightWatchController@ajaxMVTArrival'
]);


Route::get('flight-watch/run-scripts', [
    'as'                        => 'flight-watch/run-scripts',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_WATCH,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'FlightWatchController@runScripts'
]);

Route::get('flight-watch/quick-link', [
    'as'                        => 'flight-watch/quick-link',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_WATCH,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'FlightWatchController@quickLink'
]);

Route::post('flight-watch/create', [
    'as'                        => 'flight-watch/create',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_WATCH,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'FlightWatchController@create'
]);

Route::post('flight-watch/{flight}/edit', [
    'as'                        => 'flight-watch/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_WATCH,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'FlightWatchController@create'
]);

Route::post('flight-watch/cancel', [
    'as'                        => 'flight-watch/cancel',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_WATCH,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'FlightWatchController@cancel'
]);

Route::post('flight-watch/save-line', [
    'as'                        => 'flight-watch/save-line',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_WATCH,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'FlightWatchController@saveLine'
]);

