<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('flight-view', [
    'as'                        => 'flight-view/index',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_VIEW,
    'permissions'               => [VIEW_PERMISSION],
//    'user_roles'                => [DEPARTMENT_ADMIN, ADMIN, SUPER_ADMIN],
    'uses'                      => 'FlightViewController@index'
]);

Route::get('flight-view/fhr/excel/{flight}', [
    'as'                        => 'flight-view/index',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_VIEW,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'FlightViewController@fhrExcel'
//    'user_roles'                => [DEPARTMENT_ADMIN, ADMIN, SUPER_ADMIN],
]);

Route::get('flight-view/fhr/{flight}', [
    'as'                        => 'flight-view/index',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_VIEW,
    'permissions'               => [VIEW_PERMISSION],
//    'user_roles'                => [DEPARTMENT_ADMIN, ADMIN, SUPER_ADMIN],
    'uses'                      => 'FlightViewController@fhr'
]);

Route::get('flight-view/{type}', [
    'as'                        => 'flight-view/index',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_VIEW,
    'permissions'               => [VIEW_PERMISSION],
//    'user_roles'                => [DEPARTMENT_ADMIN, ADMIN, SUPER_ADMIN],
    'uses'                      => 'FlightViewController@index'
]);

Route::post('flight-view', [
    'as'                        => 'flight-view/store',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_VIEW,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'FlightViewController@store'
]);

Route::get('flight-view/{flight}/edit', [
    'as'                        => 'flight-view/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_VIEW,
    'permissions'               => [EDIT_PERMISSION],
//    'user_roles'                => [DEPARTMENT_ADMIN, ADMIN, SUPER_ADMIN],
    'uses'                      => 'FlightViewController@edit'
]);


Route::post('flight-view/cancel-selected', [
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_VIEW,
    'permissions'               => [DELETE_PERMISSION],
//    'user_roles'                => [DEPARTMENT_ADMIN, ADMIN, SUPER_ADMIN],
    'uses'                      => 'FlightViewController@cancelSelected'
]);

Route::post('flight-view/delete-selected', [
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_VIEW,
    'permissions'               => [DELETE_PERMISSION],
//    'user_roles'                => [DEPARTMENT_ADMIN, ADMIN, SUPER_ADMIN],
    'uses'                      => 'FlightViewController@deleteSelected'
]);

Route::post('flight-view/restore-selected', [
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_VIEW,
    'permissions'               => [EDIT_PERMISSION],
//    'user_roles'                => [DEPARTMENT_ADMIN, ADMIN, SUPER_ADMIN],
    'uses'                      => 'FlightViewController@restoreSelected'
]);

Route::post('flight-view/{flight}', [
    'as'                        => 'flight-view/update',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_VIEW,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'FlightViewController@update'
]);


Route::get('flight-view/create', [
    'as'                        => 'flight-view/create',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_VIEW,
    'permissions'               => [CREATE_PERMISSION],
//    'user_roles'                => [DEPARTMENT_ADMIN, ADMIN, SUPER_ADMIN],
    'uses'                      => 'FlightViewController@create'
]);

Route::get('flight-view/{flight}', [
    'as'                        => 'flight-view/show',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_VIEW,
    'permissions'               => [VIEW_PERMISSION],
//    'user_roles'                => [DEPARTMENT_ADMIN, ADMIN, SUPER_ADMIN],
    'uses'                      => 'FlightViewController@show'
]);

Route::get('flight-view/{flight}/delete', [
    'as'                        => 'flight-view/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_VIEW,
    'permissions'               => [DELETE_PERMISSION],
//    'user_roles'                => [DEPARTMENT_ADMIN, ADMIN, SUPER_ADMIN],
    'uses'                      => 'FlightViewController@delete'
]);

Route::get('flight-view/bind/{flight}', [
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_VIEW,
    'permissions'               => [EDIT_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'FlightViewController@ajaxBindFlight'
]);

//Route::get('flight/restore/{flight}', [
//    'as'                        => 'flight/restore',
//    'middleware'                => ['permissions.required'],
//    'module'                    => FLIGHT_VIEW,
//    'permissions'               => [DEPARTMENT_ADMIN, ADMIN, SUPER_ADMIN],
//    'uses'                      => 'FlightViewController@delete'
//]);
//
//Route::get('flight/cancel/{flight}', [
//    'as'                        => 'flight/cancel',
//    'middleware'                => ['permissions.required'],
//    'module'                    => FLIGHT_VIEW,
//    'permissions'               => [DEPARTMENT_ADMIN, ADMIN, SUPER_ADMIN],
//    'uses'                      => 'FlightViewController@delete'
//]);
//
//Route::get('flight/remove/{flight}', [
//    'as'                        => 'flight/remove',
//    'middleware'                => ['permissions.required'],
//    'module'                    => FLIGHT_VIEW,
//    'permissions'               => [DEPARTMENT_ADMIN, ADMIN, SUPER_ADMIN],
//    'uses'                      => 'FlightViewController@delete'
//]);
