<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('flight-staff', [
    'as'                        => 'flight-staff/index',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_STAFF,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
//    'user_roles'                => [DEPARTMENT_ADMIN, ADMIN, SUPER_ADMIN],
    'uses'                      => 'FlightStaffController@index'
]);

Route::post('flight-staff/{flight}', [
    'as'                        => 'flight-staff/store',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_STAFF,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'FlightStaffController@store'
]);

Route::get('flight-staff/{flight}/edit', [
    'as'                        => 'flight-staff/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_STAFF,
    'permissions'               => [EDIT_PERMISSION],
//    'user_roles'                => [DEPARTMENT_ADMIN, ADMIN, SUPER_ADMIN],
    'uses'                      => 'FlightStaffController@edit'
]);


Route::get('flight-staff/{flight}/create', [
    'as'                        => 'flight-staff/show',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_STAFF,
    'permissions'               => [CREATE_PERMISSION],
//    'user_roles'                => [DEPARTMENT_ADMIN, ADMIN, SUPER_ADMIN],
    'uses'                      => 'FlightStaffController@create'
]);


//Route::post('flight-staff/{flight}',      ['as' => 'flight-staff/update',      'uses' => 'FlightStaffController@update']);


Route::get('flight-staff/create', [
    'as'                        => 'flight-staff/create',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_STAFF,
    'permissions'               => [CREATE_PERMISSION],
    'user_roles'                => [DEPARTMENT_ADMIN, ADMIN, SUPER_ADMIN],
    'uses'                      => 'FlightStaffController@create'
]);

Route::get('flight-staff/{flight}/delete', [
    'as'                        => 'flight-staff/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_STAFF,
    'permissions'               => [DEPARTMENT_ADMIN, ADMIN, SUPER_ADMIN],
    'uses'                      => 'FlightStaffController@delete'
]);

