<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('flight-number', [
    'as'                        => 'flight-number/index',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_NUMBERS,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'FlightNumberController@index'
]);

Route::post('flight-number', [
    'as'                        => 'flight-number/store',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_NUMBERS,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'FlightNumberController@store'
]);

Route::get('flight-number/{flight_number}/edit', [
    'as'                        => 'flight-number/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_NUMBERS,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'FlightNumberController@edit'
]);

Route::post('flight-number/{flight_number}', [
    'as'                        => 'flight-number/update',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_NUMBERS,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'FlightNumberController@update'
]);


Route::get('flight-number/create', [
    'as'                        => 'flight-number/create',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_NUMBERS,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'FlightNumberController@create'
]);

Route::get('flight-number/{flight_number}', [
    'as'                        => 'flight-number/show',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_NUMBERS,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'FlightNumberController@show'
]);

Route::get('flight-number/{flight_number}/delete', [
    'as'                        => 'flight-number/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_NUMBERS,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'FlightNumberController@delete'
]);

