<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('flight-com', [
    'as'                        => 'flight-com/index',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'FlightComController@index'
]);

Route::get('flight-com/fhr/{flight}', [
    'as'                        => 'flight-com/fhr',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'FlightComController@fhr'
]);

Route::post('flight-com/fhr/{flight}', [
    'as'                        => 'flight-com/post-fhr',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'FlightComController@postFhr'
]);

Route::get('flight-com/flight/{flight}', [
    'as'                        => 'flight-com/flight',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'FlightComController@openFlight'
]);

Route::get('flight-com/picture/{flight_com_picture}', [
    'as'                        => 'flight-com/picture',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'FlightComController@picture',
    'skip_log'                  => true,
]);

Route::get('flight-com/load-staff', [
    'as'                        => 'flight-com/load-staff',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'FlightComController@loadStaff',
    // SKIP LOG
    'skip_log'                  => true,
]);

Route::get('flight-com/load-trc', [
    'as'                        => 'flight-com/load-trc',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'FlightComController@loadTrc',
    // SKIP LOG
    'skip_log'                  => true,
]);

Route::post('flight-com/load-messages', [
    'as'                        => 'flight-com/load-messages',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'FlightComController@loadMessages',
    // SKIP LOG
    'skip_log'                  => true,
]);

Route::post('flight-com/load-messages/{flight}', [
    'as'                        => 'flight-com/load-messages',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'FlightComController@loadMessages',
    // SKIP LOG
//    'skip_log'                  => true,
]);

Route::post('flight-com/delete-message', [
    'as'                        => 'flight-com/delete-message',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [DELETE_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'FlightComController@deleteMessage',
    // SKIP LOG
//    'skip_log'                  => true,
]);

Route::post('flight-com/unseen-messages', [
    'as'                        => 'flight-com/unseen-messages',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'FlightComController@unseenMessages',
    // SKIP LOG
    'skip_log'                  => true,
]);

Route::post('flight-com/check-in-trc', [
    'as'                        => 'flight-com/check-in-trc',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [CREATE_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'FlightComController@checkInTrc',
    // SKIP LOG
    'skip_log'                  => true,
]);

Route::post('flight-com/pts', [
    'as'                        => 'flight-com/pts',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [CREATE_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'FlightComController@pts',
    // SKIP LOG
    'skip_log'                  => true,
]);

Route::post('flight-com/ssr', [
    'as'                        => 'flight-com/ssr',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [CREATE_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'FlightComController@ssr',
    // SKIP LOG
    'skip_log'                  => true,
]);

Route::post('flight-com/occ', [
    'as'                        => 'flight-com/occ',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [BROADCAST],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'FlightComController@sendOCC',
    // SKIP LOG
    'skip_log'                  => true,
]);

Route::post('flight-com/staff', [
    'as'                        => 'flight-com/staff',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [CREATE_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'FlightComController@staff',
    // SKIP LOG
    'skip_log'                  => true,
]);


Route::post('flight-com/send-message', [
    'as'                        => 'flight-com/send-message',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [CREATE_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'FlightComController@sendMessage',
    'skip_log'                  => true,
]);

Route::post('flight-com/upload-picture', [
    'as'                        => 'flight-com/upload-picture',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [CREATE_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'FlightComController@uploadPicture',
    'skip_log'                  => true,
]);
