<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('email-notification', [
    'as'                        => 'email-notification/index',
    'middleware'                => ['permissions.required'],
    'module'                    => EMAIL_NOTIFICATION,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'EmailNotificationController@index'
]);

Route::post('email-notification', [
    'as'                        => 'email-notification/store',
    'middleware'                => ['permissions.required'],
    'module'                    => EMAIL_NOTIFICATION,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'EmailNotificationController@store'
]);

Route::get('email-notification/{email_notification}/edit', [
    'as'                        => 'email-notification/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => EMAIL_NOTIFICATION,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'EmailNotificationController@edit'
]);

Route::post('email-notification/{email_notification}', [
    'as'                        => 'email-notification/update',
    'middleware'                => ['permissions.required'],
    'module'                    => EMAIL_NOTIFICATION,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'EmailNotificationController@update'
]);


Route::get('email-notification/create', [
    'as'                        => 'email-notification/create',
    'middleware'                => ['permissions.required'],
    'module'                    => EMAIL_NOTIFICATION,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'EmailNotificationController@create'
]);

Route::get('email-notification/{email_notification}', [
    'as'                        => 'email-notification/show',
    'middleware'                => ['permissions.required'],
    'module'                    => EMAIL_NOTIFICATION,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'EmailNotificationController@show'
]);

Route::get('email-notification/{email_notification}/delete', [
    'as'                        => 'email-notification/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => EMAIL_NOTIFICATION,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'EmailNotificationController@delete'
]);

