<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('department/organization',               ['as' => 'department/organization', 'uses' => 'DepartmentController@organization']);
Route::get('department/organization/{department}',  ['as' => 'department/organization', 'uses' => 'DepartmentController@organization']);
Route::any('department/employees',                  ['as' => 'department/employees',    'uses' => 'DepartmentController@employees']);
Route::any('department/structure',                  ['as' => 'department/structure',    'uses' => 'DepartmentController@structure']);
Route::get('department/children',                   ['as' => 'department/children',     'uses' => 'DepartmentController@children']);
Route::get('department/positions',                  ['as' => 'department/positions',    'uses' => 'DepartmentController@positions']);

Route::any('department', [
    'as'                        => 'department/index',
    'middleware'                => ['permissions.required'],
    'module'                    => DEPARTMENTS,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'DepartmentController@index'
]);

Route::any('department/edit', [
    'as'                        => 'department/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => DEPARTMENTS,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'DepartmentController@edit'
]);

Route::any('department/add', [
    'as'                        => 'department/add',
    'middleware'                => ['permissions.required'],
    'module'                    => DEPARTMENTS,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'DepartmentController@add'
]);

Route::get('department/delete', [
    'as'                        => 'department/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => DEPARTMENTS,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'DepartmentController@delete'
]);
