<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('delay-code', [
    'as'                        => 'delay-code/index',
    'middleware'                => ['permissions.required'],
    'module'                    => DELAY_CODES,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'DelayCodeController@index'
]);

Route::get('delay-code/create', [
    'as'                        => 'delay-code/create',
    'middleware'                => ['permissions.required'],
    'module'                    => DELAY_CODES,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'DelayCodeController@create'
]);

Route::get('delay-code/{delay}', [
    'as'                        => 'delay-code/show',
    'middleware'                => ['permissions.required'],
    'module'                    => DELAY_CODES,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'DelayCodeController@show'
]);

Route::post('delay-code', [
    'as'                        => 'delay-code/store',
    'middleware'                => ['permissions.required'],
    'module'                    => DELAY_CODES,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'DelayCodeController@store'
]);

Route::post('delay-code/apply-changes', [
    'as'                        => 'delay-code/apply-changes',
    'middleware'                => ['permissions.required'],
    'module'                    => DELAY_CODES,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'DelayCodeController@applyChanges'
]);

Route::get('delay-code/{delay}/edit', [
    'as'                        => 'delay-code/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => DELAY_CODES,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'DelayCodeController@edit'
]);

Route::post('delay-code/{delay}', [
    'as'                        => 'delay-code/update',
    'middleware'                => ['permissions.required'],
    'module'                    => DELAY_CODES,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'DelayCodeController@update'
]);

Route::get('delay-code/{delay}/delete', [
    'as'                        => 'delay-code/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => DELAY_CODES,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'DelayCodeController@delete'
]);

Route::delete('delay-code/{delay}', [
    'as'                        => 'delay-code/destroy',
    'middleware'                => ['permissions.required'],
    'module'                    => DELAY_CODES,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'DelayCodeController@destroy'
]);


