<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */


Route::get('chat/index', [
    'as'                        => 'chat/index',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'ChatController@index'
]);

Route::get('chat/picture/{flight_com_picture}', [
    'as'                        => 'chat/picture',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'ChatController@picture',
    'skip_log'                  => true,
]);

Route::get('chat/load-staff', [
    'as'                        => 'chat/load-staff',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'ChatController@loadStaff',
    // SKIP LOG
    'skip_log'                  => true,
]);

Route::get('chat/load-trc', [
    'as'                        => 'chat/load-trc',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'ChatController@loadTrc',
    // SKIP LOG
    'skip_log'                  => true,
]);

Route::post('chat/load-messages', [
    'as'                        => 'chat/load-messages',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'ChatController@loadMessages',
    // SKIP LOG
    'skip_log'                  => true,
]);

Route::post('chat/unseen-messages', [
    'as'                        => 'chat/unseen-messages',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'ChatController@unseenMessages',
    // SKIP LOG
    'skip_log'                  => true,
]);

Route::post('chat/check-in-trc', [
    'as'                        => 'chat/check-in-trc',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [CREATE_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'ChatController@checkInTrc',
    // SKIP LOG
    'skip_log'                  => true,
]);

Route::post('chat/pts', [
    'as'                        => 'chat/pts',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [CREATE_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'ChatController@pts',
    // SKIP LOG
    'skip_log'                  => true,
]);

Route::post('chat/staff', [
    'as'                        => 'chat/staff',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [CREATE_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'ChatController@staff',
    // SKIP LOG
    'skip_log'                  => true,
]);


Route::post('chat/send-message', [
    'as'                        => 'chat/send-message',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [CREATE_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'ChatController@sendMessage',
    'skip_log'                  => true,
]);

Route::post('chat/upload-picture', [
    'as'                        => 'chat/upload-picture',
    'middleware'                => ['permissions.required'],
    'module'                    => FLIGHT_COM,
    'permissions'               => [CREATE_PERMISSION],
    'permissions_require_all'   => true,
    'user_roles'                => [],
    'uses'                      => 'ChatController@uploadPicture',
    'skip_log'                  => true,
]);
