<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('airport', [
    'as'                        => 'airport/index',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRPORTS,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'AirportController@index'
]);

Route::post('airport', [
    'as'                        => 'airport/store',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRPORTS,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'AirportController@store'
]);

Route::get('airport/{airport}/edit', [
    'as'                        => 'airport/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRPORTS,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AirportController@edit'
]);

Route::post('airport/save', [
    'as'                        => 'airport/save',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRPORTS,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AirportController@save'
]);

Route::post('airport/{airport}', [
    'as'                        => 'airport/update',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRPORTS,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AirportController@update'
]);

Route::get('airport/{airport}/offline', [
    'as'                        => 'airport/offline',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRPORTS,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AirportController@offline'
]);

Route::get('airport/{airport}/online', [
    'as'                        => 'airport/online',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRPORTS,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AirportController@online'
]);

Route::get('airport/add', [
    'as'                        => 'airport/add',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRPORTS,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'AirportController@add'
]);


Route::get('airport/create', [
    'as'                        => 'airport/create',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRPORTS,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'AirportController@create'
]);

//Locations Routes
Route::get('location/add', [
    'as'                        => 'location/add',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRPORTS,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'LocationController@add'
]);

Route::get('location/{location}/delete', [
    'as'                        => 'location/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRPORTS,
    'permissions'               => [DELETE_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'LocationController@delete'
]);

Route::post('location/save', [
    'as'                        => 'location/save',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRPORTS,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'LocationController@save'
]);
