<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('airport-license/show', [
    'as'                        => 'airport-license/show',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRPORTS_LICENSES,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'AirportLicenseController@show'
]);

Route::get('airport-license/edit-create', [
    'as'                        => 'airport-license/edit-create',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRPORTS_LICENSES,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AirportLicenseController@editCreate'
]);

Route::get('airport-license/delete', [
    'as'                        => 'airport-license/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRPORTS_LICENSES,
    'permissions'               => [DELETE_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'AirportLicenseController@delete'
]);

Route::post('airport-license/update-store', [
    'as'                        => 'airport-license/update-store',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRPORTS_LICENSES,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AirportLicenseController@updateStore'
]);

Route::get('airport-license/delete/{airport_license}', [
    'as'                        => 'airport-license/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRPORTS_LICENSES,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'AirportLicenseController@delete'
]);
