<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('airline', [
    'as'                        => 'airline/index',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES,
    'other_module_names'        => [OPERATORS],
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'AirlineController@index'
]);

Route::post('airline', [
    'as'                        => 'airline/store',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES,
    'other_module_names'        => [OPERATORS],
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'AirlineController@store'
]);

Route::get('airline/{airline}/edit', [
    'as'                        => 'airline/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES,
    'other_module_names'        => [OPERATORS],
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AirlineController@edit'
]);

Route::post('airline/save', [
    'as'                        => 'airline/save',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES,
    'other_module_names'        => [OPERATORS],
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AirlineController@save'
]);

Route::post('airline/{airline}', [
    'as'                        => 'airline/update',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES,
    'other_module_names'        => [OPERATORS],
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AirlineController@update'
]);

Route::post('airline/upload/{airline}', [
    'as'                        => 'airline/upload',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES,
    'other_module_names'        => [OPERATORS],
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AirlineController@upload'
]);

Route::delete('airline/upload/{airline}', [
    'as'                        => 'airline/upload/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES,
    'other_module_names'        => [OPERATORS],
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'AirlineController@delete'
]);

Route::get('airline/{airline}/offline', [
    'as'                        => 'airline/offline',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES,
    'other_module_names'        => [OPERATORS],
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AirlineController@offline'
]);

Route::get('airline/{airline}/online', [
    'as'                        => 'airline/online',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES,
    'other_module_names'        => [OPERATORS],
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AirlineController@online'
]);

Route::get('airline/add', [
    'as'                        => 'airline/add',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES,
    'other_module_names'        => [OPERATORS],
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'AirlineController@add'
]);


Route::get('airline/create', [
    'as'                        => 'airline/create',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES,
    'other_module_names'        => [OPERATORS],
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'AirlineController@create'
]);

Route::get('airline/{airline}', [
    'as'                        => 'airline/show',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES,
    'other_module_names'        => [OPERATORS],
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'AirlineController@show'
]);

Route::post('airline/{airline}/staff', [
    'as'                        => 'airline/add-staff',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES,
    'other_module_names'        => [OPERATORS],
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AirlineController@addStaff'
]);
