<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('airline-service', [
    'as'                        => 'airline-service',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES_SERVICES,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'AirlineServiceController@index'
]);

Route::post('airline-service/{airline_service}', [
    'as'                        => 'airline-service/update',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES_SERVICES,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AirlineServiceController@update'
]);

Route::post('airline-service', [
    'as'                        => 'airline-service/store',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES_SERVICES,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'AirlineServiceController@store'
]);

Route::delete('airline-service/{airline_service}', [
    'as'                        => 'airline-service/destroy',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES_SERVICES,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'AirlineServiceController@destroy'
]);


Route::get('airline-service/{airline_service}/edit', [
    'as'                        => 'airline-service/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES_SERVICES,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AirlineServiceController@edit'
]);


Route::get('airline-service/create', [
    'as'                        => 'airline-service/create',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES_SERVICES,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'AirlineServiceController@create'
]);

Route::get('airline-service/{airline_service}', [
    'as'                        => 'airline-service/show',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES_SERVICES,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'AirlineServiceController@show'
]);

Route::get('airline-service/{airline_service}/delete', [
    'as'                        => 'airline-service/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES_SERVICES,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'AirlineServiceController@destroy'
]);
