<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('airline-license', [
    'as'                        => 'airline-license',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES_LICENSES,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'AirlineLicenseController@index'
]);

Route::post('airline-license/update-store', [
    'as'                        => 'airline-license/update-store',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES_LICENSES,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AirlineLicenseController@updateStore'
]);

Route::delete('airline-license/{service_license}', [
    'as'                        => 'airline-license/destroy',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES_LICENSES,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'AirlineLicenseController@destroy'
]);

Route::get('airline-license/{airport_license}/edit', [
    'as'                        => 'airline-license/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES_LICENSES,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AirlineLicenseController@edit'
]);

Route::get('airline-license/create', [
    'as'                        => 'airline-license/create',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES_LICENSES,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'AirlineLicenseController@create'
]);

Route::get('airline-license/show', [
    'as'                        => 'airline-license/show',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES_LICENSES,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'AirlineLicenseController@show'
]);

Route::get('airline-license/edit-create', [
    'as'                        => 'airline-license/edit-create',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES_LICENSES,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'AirlineLicenseController@editCreate'
]);

Route::get('airline-license/delete', [
    'as'                        => 'airline-license/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES_LICENSES,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'AirlineLicenseController@delete'
]);

Route::get('airline-license/{service_license}', [
    'as'                        => 'airline-license/show-service-license',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES_LICENSES,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'AirlineLicenseController@show'
]);

//$this->get('airline-license/{airline-service_license}/edit', [
//    'as'                        => 'airline-license/edit-service-license',
//    'middleware'                => ['permissions.required'],
//    'module'                    => AIRLINES_LICENSES,
//    'permissions'               => [EDIT_PERMISSION],
//    'uses'                      => 'AirlineLicenseController@edit'
//]);

Route::post('airline-license/{service_license}', [
    'as'                        => 'airline-license/update-service-license',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINES_LICENSES,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AirlineLicenseController@update'
]);
