<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('airline-library', [
    'as'                        => 'airline-library/index',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINE_LIBRARY,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'AirlineLibraryController@index'
]);

Route::get('airline-library/{airline}', [
    'as'                        => 'airline-library/create',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINE_LIBRARY,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'AirlineLibraryController@create'
]);

Route::post('airline-library', [
    'as'                        => 'airline-library/store',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINE_LIBRARY,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'AirlineLibraryController@store'
]);

Route::get('airline-library/{airline_library}/edit', [
    'as'                        => 'airline-library/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINE_LIBRARY,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'AirlineLibraryController@edit'
]);

Route::post('airline-library/{airline_library}', [
    'as'                        => 'airline-library/update',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINE_LIBRARY,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AirlineLibraryController@update'
]);

Route::get('airline-library/{airline_library}', [
    'as'                        => 'airline-library/show',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINE_LIBRARY,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'AirlineLibraryController@show'
]);

Route::get('airline-library/delete/{airline_library}', [
    'as'                        => 'airline-library/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINE_LIBRARY,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'AirlineLibraryController@delete'
]);

Route::get('airline-library/file/{airline_library}', [
    'as'                        => 'airline-library/show-file',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINE_LIBRARY,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'AirlineLibraryController@showFile'
]);

Route::get('airline-library/file/delete/{airline_library}', [
    'as'                        => 'airline-library/delete-file',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINE_LIBRARY,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'AirlineLibraryController@deleteFile'
]);

Route::post('airline-library/file/{airline_library}', [
    'as'                        => 'airline-library/store-file',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRLINE_LIBRARY,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AirlineLibraryController@storeFile'
]);
