<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::any('aircraft', [
    'as'                        => 'aircraft/index',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRCRAFT,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'AircraftController@index'
]);

Route::any('aircraft/{aircraft}/edit', [
    'as'                        => 'aircraft/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRCRAFT,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AircraftController@edit'
]);

Route::any('aircraft/add', [
    'as'                        => 'aircraft/add',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRCRAFT,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'AircraftController@add'
]);

Route::get('aircraft/show-flights/{aircraft}', [
    'as'                        => 'aircraft/show-flights',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRCRAFT,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'AircraftController@showFlights'
]);

Route::get('aircraft/delete/{aircraft}', [
    'as'                        => 'aircraft/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRCRAFT,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'AircraftController@delete'
]);
