<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::any('aircraft/types', [
    'as'                        => 'aircraft/types',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRCRAFT_TYPES,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'AircraftController@types'
]);

Route::get('aircraft/type/{aircraft_type}', [
    'as'                        => 'aircraft/show',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRCRAFT_TYPES,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'AircraftController@showType'
]);

Route::any('aircraft/edit-type', [
    'as'                        => 'aircraft/edit-type',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRCRAFT_TYPES,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AircraftController@editType'
]);

Route::any('aircraft/add-type', [
    'as'                        => 'aircraft/add-type',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRCRAFT_TYPES,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'AircraftController@addType'
]);

Route::get('aircraft/delete-type', [
    'as'                        => 'aircraft/delete-type',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRCRAFT_TYPES,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'AircraftController@deleteType'
]);


Route::get('aircraft/{aircraft}', [
    'as'                        => 'aircraft/show',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRCRAFT,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'AircraftController@show'
]);
