<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

// AC Maintenance
Route::get('aircraft/maintenance', [
    'as'                        => 'aircraft/maintenance-list',
    'middleware'                => ['permissions.required'],
    'module'                    => AC_MAINTENANCE,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'AircraftController@maintenanceList'
]);

Route::get('aircraft/ajax-get-maintenance', [
    'as'                        => 'aircraft/ajax-get-maintenance',
    'middleware'                => ['permissions.required'],
    'module'                    => AC_MAINTENANCE,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'AircraftController@ajaxGetMaintenance'
]);

Route::get('aircraft/ajax-delete-maintenance', [
    'as'                        => 'aircraft/ajax-delete-maintenance',
    'middleware'                => ['permissions.required'],
    'module'                    => AC_MAINTENANCE,
    'permissions'               => [EDIT_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'AircraftController@ajaxDeleteMaintenance'
]);

Route::get('aircraft/maintenance/{aircraft}', [
    'as'                        => 'aircraft/maintenance',
    'middleware'                => ['permissions.required'],
    'module'                    => AC_MAINTENANCE,
    'permissions'               => [EDIT_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'AircraftController@maintenance'
]);

Route::post('aircraft/maintenance/{aircraft}', [
    'as'                        => 'aircraft/maintenance-add',
    'middleware'                => ['permissions.required'],
    'module'                    => AC_MAINTENANCE,
    'permissions'               => [EDIT_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'AircraftController@maintenanceAdd'
]);

Route::get('aircraft/maintenance/delete/{maintenance}', [
    'as'                        => 'aircraft/maintenance-delete',
    'middleware'                => ['permissions.required'],
    'module'                    => AC_MAINTENANCE,
    'permissions'               => [EDIT_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'AircraftController@maintenanceDelete'
]);
