<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('aircraft-engine', [
    'as'                        => 'aircraft-engine/index',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRCRAFT,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'AircraftEngineController@index'
]);

Route::get('aircraft-engine/{aircraft_engine}/edit', [
    'as'                        => 'aircraft-engine/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRCRAFT,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AircraftEngineController@edit'
]);

Route::get('aircraft-engine/{aircraft_engine}/delete', [
    'as'                        => 'aircraft-engine/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRCRAFT,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'AircraftEngineController@delete'
]);

Route::post('aircraft-engine/{aircraft_engine}', [
    'as'                        => 'aircraft-engine/update',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRCRAFT,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AircraftEngineController@update'
]);

Route::get('aircraft-engine/create', [
    'as'                        => 'aircraft-engine/create',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRCRAFT,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'AircraftEngineController@create'
]);

Route::post('aircraft-engine', [
    'middleware'                => ['permissions.required'],
    'module'                    => AIRCRAFT,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'AircraftEngineController@store'
]);


