<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('aircraft-certificate', [
    'as'                        => 'aircraft-certificate/index',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRCRAFT,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'AircraftCertificateController@index'
]);

Route::get('aircraft-certificate/{aircraft_certificate}/edit', [
    'as'                        => 'aircraft-certificate/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRCRAFT,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AircraftCertificateController@edit'
]);


Route::get('aircraft-certificate/{aircraft_certificate}/delete', [
    'as'                        => 'aircraft-certificate/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRCRAFT,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'AircraftCertificateController@delete'
]);


Route::post('aircraft-certificate/{aircraft_certificate}', [
    'as'                        => 'aircraft-certificate/update',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRCRAFT,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AircraftCertificateController@update'
]);

Route::get('aircraft-certificate/create', [
    'as'                        => 'aircraft-certificate/create',
    'middleware'                => ['permissions.required'],
    'module'                    => AIRCRAFT,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'AircraftCertificateController@create'
]);

Route::post('aircraft-certificate', [
    'middleware'                => ['permissions.required'],
    'module'                    => AIRCRAFT,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'AircraftCertificateController@store'
]);


