<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('agency/assign-share',       ['as' => 'agency/assign-share',         'uses' => 'AgencyController@assignShare']);

Route::get('agency', [
    'as'                        => 'agency/index',
    'middleware'                => ['permissions.required'],
    'module'                    => AGENCIES,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'AgencyController@index'
]);

Route::get('agency/{agency}/edit', [
    'as'                        => 'agency/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => AGENCIES,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AgencyController@edit'
]);

Route::post('agency/{agency}',      ['as' => 'agency/update',               'uses' => 'AgencyController@update']);


Route::get('agency/add', [
    'as'                        => 'agency/add',
    'middleware'                => ['permissions.required'],
    'module'                    => AGENCIES,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'AgencyController@add'
]);

Route::post('agency',               ['as' => 'agency/create',               'uses' => 'AgencyController@create']);

Route::post('agency/upload-photo/{id}',     ['as' => 'agency/upload',           'uses' => 'AgencyController@uploadPhoto']);
Route::delete('agency/upload-photo/{id}',   ['as' => 'agency/upload/delete',    'uses' => 'AgencyController@deletePhoto']);

Route::get('agency/{agency}', [
    'as'                        => 'agency/show',
    'middleware'                => ['permissions.required'],
    'module'                    => AGENCIES,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'AgencyController@show'
]);


//Agency Codes

Route::get('agency-code', [
    'as'                        => 'agency/codes',
    'middleware'                => ['permissions.required'],
    'module'                    => AGENCIES,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'AgencyCodeController@index'
]);

Route::get('agency-code/{agency_code}/edit', [
    'as'                        => 'agency-code/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => AGENCIES,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AgencyCodeController@edit'
]);

Route::post('agency-code/{agency_code}',      ['as' => 'agency-code/update',        'uses' => 'AgencyCodeController@update']);

Route::get('agency-code/add', [
    'as'                        => 'agency-code/add',
    'middleware'                => ['permissions.required'],
    'module'                    => AGENCIES,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'AgencyCodeController@add'
]);

Route::post('agency-code',               ['as' => 'agency-code/create',               'uses' => 'AgencyCodeController@create']);

Route::get('agency-code/link', [
    'as'                        => 'agency-code/link',
    'middleware'                => ['permissions.required'],
    'module'                    => AGENCIES,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AgencyCodeController@link'
]);

//$this->get('agency/{agency}', [
//    'as'                        => 'agency/show',
//    'middleware'                => ['permissions.required'],
//    'module'                    => AGENCIES,
//    'permissions'               => [VIEW_PERMISSION],
//    'permissions_require_all'   => true,
//    'uses'                      => 'AgencyController@show'
//]);

Route::get('agency/show-flights/{agency}', [
    'as'                        => 'agency/show-flights',
    'middleware'                => ['permissions.required'],
    'module'                    => AGENCIES,
    'permissions'               => [VIEW_PERMISSION],
    'uses'                      => 'AgencyController@showFlights'
]);

Route::get('agency/delete/{agency}', [
    'as'                        => 'agency/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => AGENCIES,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'AgencyController@delete'
]);

