<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include('general.tab-header', ['departmentName' => 'User', 'moduleName' => 'Profile'])

            <div>

                <div class="col-md-4">
                    <div class="panel panel-primary" style="">
                        <div class="panel-heading" style="position: relative;overflow:hidden; ">
                            <h3 class="panel-title">
                                <span style="float: left">{{ $user->full_name }}</span>
                                {{--                    <span style="float: right; font-weight: bold">{{ $user->position ? $user->position[0]->name : '' }}</span>--}}
                                {{ debug($user->position) }}
                            </h3>
                        </div>
                        <div class="panel-body">
                            <div style="width: 100%; margin: 0 auto;">
                                {{--User Picture Upload--}}
                                @include('forms/general/upload-picture', ['postUrl' => url("user/upload/{$userId}")])

                                <div class="tabbable" style="float: none; clear: both; height: 400px">
                                    <!-- Only required for left/right tabs -->
                                    <ul class="nav nav-tabs">
                                        <li class="active"><a href="#tab1" data-toggle="tab">@lang("content.general")</a></li>
                                        {{--<li><a href="#tab2" data-toggle="tab">Info</a></li>--}}
                                    </ul>
                                    <div class="tab-content">
                                        {{-- General Tab --}}
                                        @include('user/layouts/general-tab')
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-sm-8">
                    <div class="panel panel-primary" style="">
                        <div class="panel-heading" style="position: relative;overflow:hidden; ">

                        </div>

                        <div class="panel-body">
                            <div class="tabbable" style="float: none; clear: both; height: 400px">
                                <ul class="nav nav-tabs" id="myTab">
                                    <div class="liner"></div>
                                    <li>
                                        <a href="#leaves" data-toggle="tab" title="welcome">
                                            <i class="glyphicon glyphicon-home"></i>
                                            <span class="tabText">Leaves</span>
                                        </a>
                                    </li>

                                    <li class="{{ $selectedTab == "requests" ? "active" : "" }}">
                                        <a href="#requests" data-toggle="tab" title="welcome">
                                            <i class="glyphicon glyphicon-tasks"></i>
                                            <span class="tabText">My Requests</span>
                                        </a>
                                    </li>

                                    <li>
                                        <a href="#leave_request" data-toggle="tab" title="welcome">
                                            <i class="glyphicon glyphicon-tasks"></i>
                                            <span class="tabText">Leave Request</span>
                                        </a>
                                    </li>

                                    <li>
                                        <a href="#duty_travel_request" data-toggle="tab" title="welcome" class="not-active">
                                            <i class="glyphicon glyphicon-tasks"></i>
                                            <span class="tabText">Duty Travel Request</span>
                                        </a>
                                    </li>

                                    @if ($hasEmployees)
                                        <li class="{{ $selectedTab == "employees_requests" ? "active" : "" }}">
                                            <a href="#employees_requests" data-toggle="tab" title="welcome">
                                                <i class="glyphicon glyphicon-tasks"></i>
                                                <span class="tabText">Employees Requests</span>
                                            </a>
                                        </li>
                                    @endif

                                    <li class="{{ $selectedTab == "leave_entitlements" ? "active" : "" }}">
                                        <a href="#leave_entitlements" data-toggle="tab" title="welcome">
                                            <i class="glyphicon glyphicon-tasks"></i>
                                            <span class="tabText">Leave Entitlements</span>
                                        </a>
                                    </li>


                                </ul>
                                <div class="tab-content">
                                    <div class="tab-pane" id="leaves">
                                        @include('user.show-leaves-tab')
                                    </div>

                                    <div class="tab-pane {{ $selectedTab == "requests" ? "active" : "" }}" id="requests">
                                        @include('user.show-my-requests-tab')
                                    </div>

                                    <div class="tab-pane" id="leave_request">
                                        @include('user.request-leave-tab')
                                    </div>

                                    <div class="tab-pane" id="duty_travel_request">
                                        @include('user.show-duty-travel-request-tab')
                                    </div>

                                    @if ($hasEmployees)
                                        <div class="tab-pane {{ $selectedTab == "employees_requests" ? "active" : "" }}" id="employees_requests">
                                            @include('user.show-employees-requests-tab')
                                        </div>
                                    @endif

                                    <div class="tab-pane {{ $selectedTab == "leave_entitlements" ? "active" : "" }}" id="leave_entitlements">
                                        @include('user.show-leave-entitlements')
                                    </div>

                                    <div class="clearfix"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

        </article>

    </div>

</section>



<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

//        Apply_Multiselect();

        ApplyTableFilter("#table");

        //        google.load('visualization', '1', {'packages': ['geomap']});

//        google.setOnLoadCallback(drawRegionsMap);

        Initialize_DateRangePicker();

        function drawRegionsMap() {
                    @if (isset($countries))
                        @foreach($countries as $i => $each)
                            var data = google.visualization.arrayToDataTable({!! json_encode($each['cities']) !!});

            var options = {
                region: '{{ $i }}',
                colors: [0xFF8747, 0xFFB581, 0xc06000],
                dataMode: 'markers',
                width: '100%',
                height: '700px'
            };

            var chart = new google.visualization.GeoMap(document.getElementById('regions_div'));

            chart.draw(data, options);
            @endforeach
        @endif
    }

        $(document).ready(function () {
            $(document).on('click', 'td.status', function () {
                var _this = $(this), parent = _this.parent(), find_details = parent.nextUntil("tr.request").filter('tr.details');

                if (find_details.is(":visible")){
                    find_details.hide();
                }
                else {
                    find_details.show();
                }

            });

            $(document).on('click', 'button.hide-modify-form', function () {
                var _this = $(this), modify_form = _this.parents('div.modify_form');
                modify_form.hide();

            });

            $(document).on('click', 'button.modify', function () {
                var _this = $(this), parent = _this.parents('tr.request'), date_from = parent.find('td.date_from'),
                        date_to = parent.find('td.date_to'),
                        modify_form = $(document).find('div.modify_form'),
                        periodInput = modify_form.find('input.daterangepicker-from-now'),
                        leaveId = parent.attr('data-leave-id'),
                        start = moment(date_from.text(), "DD MMM YY").toDate(),
                        end = moment(date_to.text(), "DD MMM YY").toDate(),
                        leaveIdInput = modify_form.find('select[name=leave_id]').val(leaveId),
                        leaveRequestId = parent.attr('data-request-id'),
                        leaveRequestIdInput = modify_form.find('input[type=hidden][name=leave_request_id]');



                if (modify_form.is(":visible")){
                    if (leaveRequestIdInput.val() == leaveRequestId){
                        modify_form.hide();

                    }
                    else {
                        leaveRequestIdInput.val(leaveRequestId);
                        leaveIdInput.multiselect('rebuild');
                        periodInput.daterangepicker("setRange", {start: start, end: end});
                    }
                }
                else {
                    leaveIdInput.multiselect('rebuild');
                    leaveRequestIdInput.val(leaveRequestId);
                    periodInput.daterangepicker("setRange", {start: start, end: end});
                    modify_form.show();
                }

            });
        });
    };

    loadScript("https://www.google.com/jsapi",  pagefunction);

</script>





