<div class="jarviswidget jarviswidget-color-blueDark" id="wid-my-requests-tab" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>
        <h2>@lang("content.list")</h2>
    </header>

    <!-- widget div-->
    <div>

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding" style="min-height: 50px !important;">

            <div class="table-responsive editable_div">

                <table class="table table-bordered table-striped table-hover">
                <thead>
                <tr>
                    <th>No</th>
                    <th>@lang("content.status")</th>
                    <th>@lang("content.leave_type")</th>
                    <th>@lang("content.days")</th>
                    <th style="width: 90px">@lang("content.from")</th>
                    <th style="width: 90px">@lang("content.to")</th>
                    <th>@lang("content.document")</th>
                    <th>@lang("content.reason")</th>
                    <th>@lang("content.notes")</th>
                    <th style="width: 120px;">@lang("content.last_updated")</th>
                    <th style="width: 150px;">@lang("content.actions")</th>
                </tr>
                </thead>
                <tbody>

                    @foreach($leaveRequests as $i => $each)
                        @php
                            $reqStatus = $each->status ? $each->status->status : APPLICATION_STATUS_PENDING;
                            $span = applicationStatusSpan($reqStatus)
                        @endphp

                        <tr class="request" style="cursor:pointer" data-request-id="{{ $each->id }}" data-leave-id="{{ $each->leave_id }}">
                            <td>{{ $i + 1 }}</td>
                            <td class="status-prev">{!! $span !!}</td>
                            <td class="status-prev">
                                <span style="border-bottom: 1px dashed #cc3341 !important;">
                                    {{ $each->leave->name }}
                                </span>
                            </td>
                            <td class="status-prev">{{ $each->days ? $each->days : 1 }}</td>
                            <td class="date_from">{{ baseDateFormat($each->date_from) }}</td>
                            <td class="date_to">{{ baseDateFormat($each->date_to) }}</td>
                            <td>
                                @if ($each->doc1)
                                    <a target="_blank" href="{{ url("user/leave-request/picture/{$each->id}") }}">Document</a>
                                @endif
                            </td>
                            <td>{{ $each->reasons }}</td>
                            <td>{!! $each->notes !!}</td>
                            <td>{{ baseDateFormat($each->updated_at, true) }}</td>
                            <td>
                                @if(!$each->status || ($each->status->status != APPLICATION_STATUS_DECLINED && $each->status->status != APPLICATION_STATUS_CANCELLED))
                                    @if (strtotime($each->date_to) > strtotime(date("Y-m-d")))
                                        <div class="col-sm-6 padding-0 margin-0">
                                            {!! Form::open(['class' => 'form-inline', 'method' => 'POST', 'url' => url("user/leave-employee-actions")]) !!}
                                                {!! Form::hidden('leave_request_id', $each->id) !!}
                                                {!! Form::hidden('cancel', 1) !!}
                                                {!! Form::submit(trans("content.cancel"), ['class' => 'btn btn-danger btn-sm']) !!}
                                            {!! Form::close() !!}
                                        </div>
                                    @endif
                                    @if ($each->status && $each->status->status == APPLICATION_STATUS_CHANGE)
                                        <div class="col-sm-6 padding-0 margin-0">
                                            {!! Form::open(['class' => 'form-inline', 'method' => 'POST', 'url' => url("user/leave-employee-actions")]) !!}
                                                {!! Form::hidden('leave_request_id', $each->id) !!}
                                                {!! Form::hidden('change', 1) !!}
                                                {!! Form::button(trans("content.modify"), ['class' => 'btn btn-warning modify btn-sm']) !!}
                                            {!! Form::close() !!}
                                        </div>
                                    @endif
                                @endif
                            </td>
                        </tr>
                        @if (count($each->leaveStatus))
                            <tr class="details" style="display:none;">
                                <td colspan="11" style="background-color: #84878c;">
                                    <table class="table table-bordered table-striped table-hover">
                                        <thead></thead>
                                        <tbody>
                                        <tr>
                                            <th class="td_header">No</th>
                                            <th class="td_header">@lang("content.pending_with")</th>
                                            <th class="td_header">@lang("content.station")</th>
                                            <th class="td_header">@lang("content.position")</th>
                                            <th class="td_header">@lang("content.message")</th>
                                            <th class="td_header">@lang("content.reviewed_at")</th>
                                            <th class="td_header">@lang("content.status")</th>
                                        </tr>
                                        @foreach($each->leaveStatus as $j => $eachStatus)
                                            @php $user = $eachStatus->user @endphp
    {{--                                        @php $organization = $eachStatus->organization @endphp --}}
    {{--                                        @php $position = $organization ? $organization->position : null @endphp --}}
                                            @php $span = applicationStatusSpan($eachStatus->status->status) @endphp
                                            <tr>
                                                <td>{{ $j + 1 }}</td>
                                                <td>{{ $user ? $user->first_name ." ".$user->last_name : ""}}</td>
                                                <td>{{ getUserLocation($user) }}</td>
                                                <td>{{ getUserPositionName($user) }}</td>
                                                <td>{!! $eachStatus->notes !!}</td>
                                                <td>{{ $eachStatus->reviewed_at ? baseDateFormat($eachStatus->reviewed_at, true) : baseDateFormat($eachStatus->updated_at, true) }}</td>
                                                <td>{!! $span !!}</td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </td>
                            </tr>
                        @endif
                    @endforeach
                </tbody>
            </table>

            </div>

            <div class="col-lg-12 modify_form" style="display: none;">
            {!! Form::open(['class' => 'form-inline', 'method' => 'POST', 'url' => url("/user/leave-employee-actions")]) !!}
                <hr/>
                <h4>@lang("content.modify_leave_form")</h4>

                <div class="form-group marginBottomRight">
                    <label>@lang("content.leave_type")</label>
                    <div class="btn-group">
                        {!! Form::select('leave_id', $leaves, null, ['class'=>'singleselect']) !!}
                    </div>
                </div>

                <div class="form-group marginLeftRightBottom">
                    <label>@lang("content.period")
                        {!! Form::text('date_period', \request("datePeriod"), ['class'=>'form-control daterangepicker-from-now']) !!}
                    </label>
                </div>


                <div class="form-group marginBottomRight">
                    <label>@lang("content.reasons")</label><br>
                    {!! Form::textarea('reasons', null, ['cols' => 100]) !!}
                </div>

                <br/>
                <div class="btn-group marginBottomRight">
                    {!! Form::hidden('leave_request_id', "") !!}
                    {!! Form::button(trans("content.discard"), ['name' => 'cancel', 'class' => 'btn btn-danger hide-modify-form btn-sm']) !!}
                    {!! Form::submit(trans("content.modify"), ['name' => 'change', 'class' => 'btn btn-warning btn-sm']) !!}
                </div>

            {!! Form::close() !!}
            </div>

        </div>

    </div>

</div>