@php $currentYear = (int)date('Y') @endphp
@php $nextYear = $currentYear + 1 @endphp

<div class="jarviswidget jarviswidget-color-blueDark" id="wid-leave-leave-requests-tab" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>
        <h2>@lang("content.entitlement")(@lang("content.annual_leave"))</h2>
    </header>

    <!-- widget div-->
    <div>

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding" style="min-height: 50px !important;">

            <table class="table table-bordered table-striped table-hover" id="entitlementTable">
                <thead>
                <tr>
                    <th>@lang("content.year")</th>
                    <th>@lang("content.entitlement")(@lang("content.days"))</th>
                    <th>@lang("content.leave_type")</th>
                    <th>@lang("content.pending")(@lang("content.days"))</th>
                    <th>@lang("content.used")(@lang("content.days"))</th>
                    <th>@lang("content.balance")(@lang("content.days"))</th>
                </tr>
                </thead>
                <tbody>
                <tr>
                    <td>{{ $currentYear }}</td>
                    <td>{{ $days = (isset($entitlements[$currentYear]) ? $entitlements[$currentYear]->entitlement : "") }}</td>
                    <td>{{ isset($entitlements[$currentYear]) ? $entitlements[$currentYear]->type : trans("content.calendar") }} days</td>
                    <td>{{ $pending = (isset($entitlements[$currentYear]) ? $entitlements[$currentYear]->pending : "") }}</td>
                    <td>{{ $used = (isset($entitlements[$currentYear]) ? $entitlements[$currentYear]->used : "") }}</td>
                    <td>{{ $days ? ($days - ($used ? $used : 0) - ($pending ? $pending : 0)) : "" }}</td>
                </tr>
                <tr>
                    <td>{{ $nextYear }}</td>
                    <td>{{ $days = (isset($entitlements[$nextYear]) ? $entitlements[$nextYear]->entitlement : "") }}</td>
                    <td>{{ isset($entitlements[$nextYear]) ? $entitlements[$nextYear]->type : trans("content.calendar") }} days</td>
                    <td>{{ $pending = (isset($entitlements[$nextYear]) ? $entitlements[$nextYear]->pending : "") }}</td>
                    <td>{{ $used = (isset($entitlements[$nextYear]) ? $entitlements[$nextYear]->used : "") }}</td>
                    <td>{{ $days ? ($days - ($used ? $used : 0) - ($pending ? $pending : 0)) : "" }}</td>
                </tr>
                </tbody>
            </table>

        </div>
    </div>
</div>

<div class="col-md-12" style=" padding-left: 0;">

    <h4 style="margin: 0 0 20px 0;">@lang("content.request_form")</h4>

    <div class="col-md-12">
    {!! Form::open(['class' => 'form-horizontal exclude-form', 'files' => true, 'method' => 'POST', 'url' => url("user/leave-apply")]) !!}

        <div class="form-group">
            <label class="col-md-2">@lang("content.leave_type")</label>
            <div class="col-md-6">
                {!! Form::select('leave_id', $leaves, \request("leave_id"), ['class' => 'input_200']) !!}
            </div>
        </div>


{{--        <div class="form-group">--}}
{{--            <label class="col-md-2">@lang("content.other")</label>--}}
{{--            <div class="col-md-6">--}}
{{--                {!! Form::select('other_leave_id', $otherLeaves, \request("other_leave_id"), ['class' => 'input_200']) !!}--}}
{{--            </div>--}}
{{--        </div>--}}

        <div class="form-group">
            <label class="col-md-2">Attach document</label>
            <div class="col-md-6">
                {!! Form::file('file') !!}
            </div>
        </div>

        <div class="form-group">
            <label class="col-md-2">@lang("content.period")</label>
            <div class="col-md-6">
                {!! Form::text('date_period', \request("datePeriod"), ['class'=>'form-control daterangepicker-from-now']) !!}
            </div>
        </div>


        <div class="form-group">
            <label>@lang("content.reasons")</label><br>
            {!! Form::textarea('reasons', null, ['cols' => 100, 'rows' => 5]) !!}
            {!! Form::hidden("tab", "leave_request") !!}
            {!! Form::hidden("user_id", $userId) !!}
        </div>

        <div class="form-group">
            <button type="submit" class="btn btn-danger">@lang("content.cancel")</button>
            <button type="submit" class="btn btn-success">@lang("content.apply")</button>
        </div>

    {!! Form::close() !!}

    </div>

</div>