<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 11.08.14

 */
?>
@extends($ajaxCall)
@section("content")

<style type="text/css">
    #subdepartment, #position, #other_position {
        display: none;
    }
</style>

<h2 class="form-signup-heading">Please Register</h2>
<hr/>
{!! Form::open(array('method' => 'GET', 'url' => 'register', 'class' => 'form-signup form-horizontal')) !!}

{{-- Validation errors block --}}
@if ($errors->count())
<div class="alert alert-danger">
<h4>Validation Errors:</h4>
<ul>
    @foreach ($errors->all() as $error)
    <li>{!! $error !!}</li>
    @endforeach
</ul>
</div>
@endif

{{-- Message block --}}
<div id="messages"></div>
<div class="form-group">
    {!! Form::label('first_name', 'First Name', ['class'=>'col-sm-3 control-label', "required"=>"required"]) !!}
    <div class="col-sm-9">
        {!! Form::text('first_name', null, array('class'=>'input-block-level form-control', 'placeholder'=>'First Name',
        'id' => 'first_name', "required"=>"required")) !!}
    </div>
</div>
<div class="form-group">
    {!! Form::label('last_name', 'Last Name', ['class'=>'col-sm-3 control-label', "required"=>"required"]) !!}
    <div class="col-sm-9">
        {!! Form::text('last_name', null, array('class'=>'input-block-level form-control', 'placeholder'=>'Last Name',
        'id' => 'last_name', "required"=>"required" )) !!}
    </div>
</div>
<div class="form-group">
    <label class="col-sm-3 control-label">@lang("content.department")</label>
    <div class="col-sm-9">
        {!! Form::select('department_id', $departments, \request()->old('department_id'), ['class' => 'form-control', 'id' =>
        'department_id', "required" => "required"]) !!}
    </div>
</div>
<div class="form-group" id="subdepartment">
    <label for="subdepartment_id" class="col-sm-3 control-label">Subdivision</label>
    <div class="col-sm-9">
        {!! Form::select('subdepartment_id', [""=>"Select Subdivision"], \request()->old('subdepartment_id'), ['class' => 'form-control',
        'id'=>'subdepartment_id']) !!}
    </div>
</div>
<div class="form-group" id="position">
    <label for="position_id" class="col-sm-3 control-label">@lang("content.position")</label>
    <div class="col-sm-9">
        {!! Form::select('position_id', [""=>"Select Position"], \request()->old('position_id'), ['class' => 'form-control', 'id'=>'position_id',
         "required"=>"required"])!!}
    </div>
</div>
<div class="form-group" id="other_position">
    {!! Form::label('other_position_value', 'Other Position', ['class' => 'col-sm-3 control-label']) !!}
    <div class="col-sm-9">
        {!! Form::text('other_position', null, array('class'=>'input-block-level form-control',
        'placeholder'=>'Position', 'autocomplete' => 'off', 'id' => 'other_position_value')) !!}
        <span class="help-block">Please specify your current position</span>
    </div>
</div>
<div class="form-group">
    {!! Form::label('email', 'Email Address', ['class' => 'col-sm-3 control-label']) !!}
    <div class="col-sm-9">
        {!! Form::email('email', null, array('class'=>'input-block-level form-control', 'placeholder'=>'Email Address',
        'autocomplete' => 'off', 'id' => 'email', "required"=>"required")) !!}
    </div>
</div>
<div class="form-group" id="staff">
    <label for="staff" class="col-sm-3 control-label">Staff</label>
    <div class="col-sm-9">
        {!! Form::select('staff', $staff, null, ['class' => 'form-control', 'id'=>'staff',"required"=>"required"])!!}
    </div>
</div>
<div class="form-group">
    {!! Form::label('password', 'Password', ['class' => 'col-sm-3 control-label']) !!}
    <div class="col-sm-9">
        {!! Form::password('password', array('class'=>'input-block-level form-control', 'placeholder'=>'Password', 'id'
        => 'password', "required"=>"required")) !!}
    </div>
</div>
<div class="form-group">
    {!! Form::label('password_confirmation', 'Password Confirmation', ['class' => 'col-sm-3 control-label']) !!}
    <div class="col-sm-9">
        {!! Form::password('password_confirmation', array('class'=>'input-block-level form-control',
        'placeholder'=>'Confirm Password', 'id' => 'password_confirmation', "required"=>"required")) !!}
    </div>
</div>
<div class="form-group">
    {!! Form::submit('Register', array('class'=>'btn btn-large btn-primary', 'id' => 'submit_button'))!!}
    <a href="{!! URL::route('user/login') !!}" class="btn btn-default">Back</a>
</div>
{!! Form::close() !!}
@stop

@section("js_scripts")
<script src="{!! route("homepage")."#". url("/") !!}/assets/js/views/user/register.js"></script>
@stop
