<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 19.08.14

 */

if (isset($user) && is_object($user) && isset($user->passport)) {
    $passport = unserialize($user->passport);
    if (!isset($passport["p_exp_date"])) {
        $passport["p_exp_date"] = "";
    }
    if (!isset($passport["p_issued_date"])) {
        $passport["p_issued_date"] = "";
    }
    if (!isset($passport["p_number"])) {
        $passport["p_number"] = "";
    }
} else {
    $passport = [
        "p_number" => "",
        "p_issued_date" => "",
        "p_exp_date" => ""
    ];
}
if (isset($user) && is_object($user) && isset($user->phone)) {
    $phone = unserialize($user->phone);
    if (!isset($phone["office"])) {
        $phone["office"] = "";
    }
    if (!isset($phone["home"])) {
        $phone["home"] = "";
    }
    if (!isset($phone["mobile1"])) {
        $phone["mobile1"] = "";
    }
    if (!isset($phone["mobile2"])) {
        $phone["mobile2"] = "";
    }
} else {
    $phone = [
        "office" => "",
        "home" => "",
        "mobile1" => "",
        "mobile2" => ""
    ];
}

?>
@extends($ajaxCall)
@section("content")
<style type="text/css">
    div.form-inline .form-group {
        margin-left: 15px;
    }
</style>


@include('general.tab-header', ['departmentName' => 'User', 'moduleName' => "Profile Update"])

<div class="row" style="padding-bottom: 50px">
    @if ($errors->all())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{!! $error !!}</li>
            @endforeach
        </ul>
    </div>
    @elseif ( Session::has('message'))
    <div class="alert alert-success">
        {!! Session::get('message')!!}
    </div>

    @endif
    <div style="width: 30%; max-width: 300px; float: left; margin: 15px" >

        <div class="form-inline" style="width: 100%">
            <?php
            if ($user->picture)
                $picture = route("homepage")."#". url('/')."/storage/users/".$user->picture;
            else
                $picture = route("homepage")."#". url('/')."/assets/img/default-user-picture.png";
            ?>
            <img class="picture" src="{!!$picture!!}" />
        </div>

      </div>

    <div style="border-left: 1px solid #d0d8e0; width: 65%; max-width: 800px; float:left;">
        <form class="form-horizontal" method="post">
            <div class="form-group">
                <label class="control-label col-sm-3">@lang("content.first_name")</label>
                <div class="col-sm-9">
                    {!! Form::text('first_name', $user->first_name, ['class'=>'form-control', 'placeholder'=>'First Name', 'id'=>'first_name', 'disabled']) !!}

                </div>
            </div>
            <div class="form-group">
                <label class="control-label col-sm-3">@lang("content.last_name")</label>
                <div class="col-sm-9">
                    {!! Form::text('last_name', $user->last_name, ['class'=>'form-control', 'placeholder'=>'Last Name', 'id'=>'last_name', 'disabled']) !!}

                </div>
            </div>
            <div class="form-group has">
                <label class="control-label col-sm-3">@lang("content.email")</label>
                <div class="col-sm-9">
                    {!! Form::text('email', $user->email, ['class'=>'form-control', 'placeholder'=>'Email', 'id'=>'email', 'disabled']) !!}

                </div>
            </div>

            <div class="form-group has">
                <label class="control-label col-sm-3">@lang("content.date_of_birth")</label>
                <div class="col-sm-9">
                    {!! Form::text('dob', $user->dob, ['class'=>'form-control datepicker', 'placeholder'=>'YYYY-MM-DD', 'id'=>'dob', 'readonly']) !!}

                </div>
            </div>
            <div class="form-group">
                <label class="control-label col-sm-3">@lang("content.place_of_birth")</label>
                <div class="col-sm-9">
                    {!! Form::text('birth_place', $user->birth_place, ['class'=>'form-control ', 'id'=>'birth_place', 'disabled']) !!}
                </div>
            </div>
            <div class="form-group">
                <label class="col-sm-3 control-label">@lang("content.department")</label>
                <div class="col-sm-9">
                    {!! Form::text('department_id', $department, ['class' => 'form-control', 'id' =>'department_id', 'disabled']) !!}
                </div>
            </div>
            @if ($subdepartment)
            <div class="form-group" id="subdepartment" style="">
                <label for="subdepartment_id" class="col-sm-3 control-label">Subdivision</label>
                <div class="col-sm-9">
                    {!! Form::text('subdepartment_id', $subdepartment, ['class' => 'form-control', 'id'=>'subdepartment_id', 'disabled']) !!}
                </div>
            </div>
            @endif
            <div class="form-group" id="position">
                <label for="position_id" class="col-sm-3 control-label">@lang("content.position")</label>
                <div class="col-sm-9">
                    {!! Form::text('position_id', $position, ['class' => 'form-control', 'id'=>'position_id', 'disabled'])!!}
                </div>
            </div>
            <div class="form-group" id="other_position" style="display: none">
                <label for="position_id" class="col-sm-3 control-label">@lang("content.other_position")</label>
                <div class="col-sm-9">
                    {!! Form::text('other_position', null, array('class'=>'input-block-level form-control',
                    'placeholder'=>'Position', 'autocomplete' => 'off', 'id' => 'other_position_value')) !!}
                    <span class="help-block">Please specify your current position</span>
                </div>
            </div>
            <div class="form-group">
                <label class="control-label col-sm-3">@lang("content.contractor")</label>
                <div class="col-sm-9">
                    <label class="checkbox-inline">
                        {!! Form::checkbox('is_contractor', 1, $user->is_contractor, ['id'=>'is_contractor', 'disabled']) !!} Yes / No
                    </label>
               </div>
           </div>
            <div class="form-group">
                <label class="control-label col-sm-3">@lang("content.language")</label>
                <div class="col-sm-9">
                    <?php $languages = ($user->languages) ? unserialize($user->languages) : [];?>
                    <label class="checkbox-inline">
                        <?php $checked = (in_array(LANG_TAJIK, $languages));?>
                        {!! Form::checkbox('language[]', 'tajik', $checked, ['id'=>'language-tajik', 'disabled']) !!} Tajik
                    </label>
                    <label class="checkbox-inline">
                        <?php $checked = (in_array(LANG_RUSSIAN, $languages));?>
                        {!! Form::checkbox('language[]', 'russian', $checked, ['id'=>'language-russian', 'disabled']) !!} Russian
                    </label>
                    <label class="checkbox-inline">
                        <?php $checked = (in_array(LANG_ENGLISH, $languages));?>
                        {!! Form::checkbox('language[]', 'english', $checked, ['id'=>'language-english', 'disabled']) !!} English
                    </label>
                    <label class="checkbox-inline">
                        <?php $checked = (in_array(LANG_GERMAN, $languages));?>
                        {!! Form::checkbox('language[]', 'german', $checked, ['id'=>'language-german', 'disabled']) !!} German
                    </label>
                    <label class="checkbox-inline">
                        <?php $checked = (in_array(LANG_CHINESE, $languages));?>
                        {!! Form::checkbox('language[]', 'chinese', $checked, ['id'=>'language-chinese', 'disabled']) !!} Chinese
                    </label>
                </div>
            </div>
            <div class="form-group">
                <label class="control-label col-sm-3">@lang("content.location")</label>
                <div class="col-sm-9">
                    {!! Form::text('location',$user->location, ['class'=>'form-control', 'id'=>'location', 'disabled']) !!}
                </div>
            </div>
            <div class="form-group">
                <label class="control-label col-sm-3">@lang("content.nationality")</label>
                <div class="col-sm-9">
                    {!! Form::text('nationality', $user->nationality, ['class'=>'form-control ', 'id'=>'nationality', 'disabled']) !!}
                </div>
            </div>

            <div class="form-group">
                <label class="control-label col-sm-3">@lang("content.passport")</label>
                <div class="col-sm-9">
                    <div class="form-inline">
                        <div class="form-group">
                            <label>No.</label>
                            {!! Form::text('p_number', $passport['p_number'], ['class'=>'form-control input-sm', 'id'=>'p_number', 'disabled']) !!}
                        </div>
                        <div class="form-group">
                            <label>@lang("content.issued")</label>
                            {!! Form::text('p_issued_date', $passport['p_issued_date'], ['class'=>'form-control input-sm datepicker', 'id'=>'p_issued_date', 'disabled']) !!}
                        </div>
                        <div class="form-group">
                            <label>Exp.</label>
                            {!! Form::text('p_exp_date', $passport['p_exp_date'], ['class'=>'form-control input-sm datepicker', 'id'=>'p_exp_date', 'disabled']) !!}
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <label class="control-label col-sm-3">ID Card</label>
                <div class="col-sm-9">
                    <div class="form-inline">
                        <div class="form-group">
                            <label>No.</label>
                            {!! Form::text('idcard_number', $user->idcard_number, ['class'=>'form-control input-sm', 'id'=>'idcard_number', 'disabled']) !!}
                        </div>
                        <div class="form-group">
                            <label>@lang("content.expiry")</label>
                            {!! Form::text('idcard_expiration', $user->idcard_expiration, ['class'=>'form-control input-sm datepicker', 'id'=>'idcard_expiration', 'disabled']) !!}
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <label class="control-label col-sm-3">@lang("content.phone")</label>
                <div class="col-sm-9">
                    <div class="form-inline" style="width: 120%">
                        <div class="form-group">
                            <label>@lang("content.office")</label>
                            {!! Form::text('phone_office', $phone['office'], ['class'=>'form-control input-sm', 'id'=>'phone_office', 'disabled']) !!}
                        </div>
                        <div class="form-group">
                            <label>@lang("content.home")</label>
                            {!! Form::text('phone_home', $phone['home'], ['class'=>'form-control input-sm', 'id'=>'phone_home', 'disabled']) !!}
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <label class="control-label col-sm-3">@lang("content.mobile")</label>
                <div class="col-sm-9">
                    <div class="form-inline" style="width: 120%">
                        <div class="form-group">
                            <label>No 1</label>
                            {!! Form::text('phone_mobile1', $phone['mobile1'], ['class'=>'form-control input-sm', 'id'=>'phone_mobile1', 'disabled']) !!}
                        </div>
                        <div class="form-group">
                            <label>No 2</label>
                            {!! Form::text('phone_mobile2', $phone['mobile2'], ['class'=>'form-control input-sm', 'id'=>'phone_mobile2', 'disabled']) !!}
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="col-sm-offset-3 col-sm-9">
                    <a href="{!! route("homepage")."#". url("admin/users") !!}" class="btn btn-default">Back</a>
                </div>
            </div>
        </form>
    </div>



</div>
@stop

@section("js_scripts")
<script src="{!! route("homepage")."#". url("/") !!}/assets/js/views/user/edit.js"></script>
@stop
