@php $edit = isset($edit) ? $edit : false @endphp

{{--Basic Information Header--}}
@include('layouts/list-title', ['title' => 'Basic Information'])

@if ($edit)
    <?php $attributes = [
            ['name' => 'first_name','value' => $user->first_name,      'label' => 'First Name',  'required' => true,          'icon' => 'asterisk'],
            ['name' => 'last_name', 'value' => $user->last_name,       'label' => 'Last Name',   'required' => true,          'icon' => 'asterisk'],
            ['type' => 'email',     'name'  => 'email',                'value' => $user->email,  'label' => 'Email',          'required'    => true,            'icon' => 'asterisk'],
            ['name' => 'dob',       'value' => $user->dob,             'label' => 'DOB',         'class' => 'datepicker',     'placeholder' => 'Date Of Birth', 'icon' => 'calendar'],
            ['type' => 'select',    'name' => 'gender',                'selections' => $gender,  'emptySelection' => true,    'selected' => $user->gender,      'label'=> 'Gender', 'icon' => false],
            ['type' => 'password',  'name' => 'current_password',      'label' => 'Current Password'],
            ['type' => 'password',  'name' => 'password',              'label' => 'Password'],
            ['type' => 'password',  'name' => 'password_confirmation', 'label' => 'Confirm Password'],
        ]; ?>
    @include('layouts/list-form-array', ['attributes' => $attributes])
@else
    <?php $attributes = [
            ['title' => 'First Name', 'value' => $user->first_name],
            ['title' => 'Last Name', 'value' => $user->last_name],
            ['title' => 'Email', 'value' => $user->email],
            ['title' => 'DOB', 'value' => $user->dob],
            ['title' => 'Gender', 'value' => $user->gender],
        ]; ?>
    @include('layouts/profile-list-array', ['attributes' => $attributes])
@endif
{{--Work Header--}}
@include('layouts/list-title', ['title' => 'Work'])

@if ($edit)
    <?php $attributes = [
            ['name' => 'doj', 'value' => $user->doj, 'label' => 'DOJ', 'class' => 'datepicker', 'placeholder' => 'Date Of Joining', 'icon' => 'calendar'],
            ['type' => 'select', 'name' => 'structure_department_id', 'selections' => $departments, 'selected' => $department, 'label' => 'Department', 'required' => true, 'icon' => false],
            ['type' => 'select', 'name' => 'structure_position_id', 'selections' => $positions, 'selected' => $position, 'label' => 'Position', 'icon' => false],
            ['type' => 'select', 'name' => 'reports_to_user_id', 'selections' => $usersList, 'selected' => $user->reports_to_user_id, 'label' => 'Reports To', 'icon' => false],
         ];   ?>
    @include('layouts/list-form-array', ['attributes' => $attributes])
@else
    <?php $attributes = [
            ['title' => 'DOJ', 'value' => $user->doj],
            ['title' => 'Department', 'value' => $department->name],
            ['title' => 'Position', 'value' => $position]
        ]; ?>

    @include('layouts/profile-list-array', ['attributes' => $attributes])

@endif



{{--@include('layouts/list-title')--}}


