@php $authUser = Auth::user() @endphp
@php $selectedStatus = isset($selectedStatus) ? $selectedStatus : null @endphp
@php $hideForm = isset($hideForm) && $hideForm @endphp

<table class="table table-bordered table-striped table-hover table-filter">
    <thead>
        <tr>
            <th>No</th>
            <th>@lang("content.status")</th>
            <th>@lang("content.application_status")</th>
            <th>@lang("content.requests")</th>
            <th style="min-width: 100px">@lang("content.period")</th>
            <th>@lang("content.days")</th>
            <th>@lang("content.employee")</th>
            <th>@lang("content.station")</th>
            <th>@lang("content.document")</th>
            <th>@lang("content.reasons")</th>
            <th>@lang("content.status_notes")</th>
            <th style="min-width: 120px;">@lang("content.last_updated")</th>
            @if (!$hideForm)
                <th>@lang("content.actions")</th>
            @endif
        </tr>
    </thead>
    <tbody>
        @php $k = 0 @endphp
        @foreach($employeesStatus as $j => $each)
{{--            @php $position = $each->leaveRequest->user->position ? $each->leaveRequest->user->position : null @endphp --}}
            @php $status = $each->status->status @endphp
            @php $statusByMe = applicationStatusSpan($status) @endphp
            @php $reqStatus = $each->leaveRequest->status ? $each->leaveRequest->status->status : APPLICATION_STATUS_PENDING; @endphp
            @php $applicationStatus = applicationStatusSpan($reqStatus) @endphp

            @if ($selectedStatus)
                @if( $selectedStatus != $status)
                    @continue
                @elseif($each->leaveRequest->status && $selectedStatus != $each->leaveRequest->status->status && $each->leaveRequest->status->status == APPLICATION_STATUS_APPROVED)
                    @continue
                @endif
            @endif

            @php $title = $each->leaveRequest->user->first_name ." ".$each->leaveRequest->user->last_name." | ". $each->leaveRequest->leave->name. " | Period: ". baseDateFormat($each->leaveRequest->date_from, false, "-") . " - ".baseDateFormat($each->leaveRequest->date_to, false, "-") @endphp

            <tr class="request" style="cursor:pointer" data-title="{{ $title }}" data-request-id="{{ $each->leaveRequest->id }}" data-leave-id="{{ $each->leaveRequest->leave_id }}">
                <td>{{ ++$k }}</td>
                <td class="status">
                    @if ($authUser->id == $each->report_to_user_id)
                        {!! $statusByMe !!}
                    @endif
                </td>
                <td class="status">{!! $applicationStatus !!}</td>
                <td class="status">
                    <span style="border-bottom: 1px dashed #cc3341 !important;">
                        {{ $each->leaveRequest->leave->name }}
                    </span>
                </td>
                <td>{!! baseDateFormat($each->leaveRequest->date_from, false, "-") . "<br/>".baseDateFormat($each->leaveRequest->date_to, false, "-") !!}</td>
                <td>{{ $each->leaveRequest->days ? $each->leaveRequest->days : 1 }}</td>
                <td>{{ $each->leaveRequest->user->first_name ." ".$each->leaveRequest->user->last_name }}</td>
                <td>{{ getUserLocation($each->leaveRequest->user) }}</td>
                <td>
                    @if ($each->leaveRequest->doc1)
                        <a target="_blank" href="{{ url("user/leave-request/picture/{$each->leaveRequest->id}") }}">Document</a>
                    @endif
                </td>
                <td>{{ $each->leaveRequest->reasons }}</td>
                <td>{!! $each->leaveRequest->notes !!}</td>
                <td>{{ baseDateFormat($each->updated_at, true) }}</td>

                @if (!$hideForm)
                    <td>
                        @if ($authUser->id == $each->report_to_user_id && in_array($status, [APPLICATION_STATUS_PENDING])
                            && (!$each->leaveRequest->status || $each->leaveRequest->status->status != APPLICATION_STATUS_APPROVED))
                            <div class="row">
                                {!! Form::open(['class' => 'form-inline application-forms', 'method' => 'POST', 'url' => url("/user/leave-manager-actions")]) !!}
                                    <div class="col-sm-12">
                                        {!! Form::hidden('leave_status_id', $each->id) !!}
                                        <label>
                                            {!! Form::radio("action", "approve", null, ["class" => "form-control", "required"]) !!}
                                            Approve
                                        </label>

                                        <label>
                                            {!! Form::radio("action", "decline", null, ["class" => "form-control", "required"]) !!}
                                            Decline
                                        </label>

                                        <label>
                                            {!! Form::radio("action", "change", null, ["class" => "form-control", "required"]) !!}
                                            Change
                                        </label>
                                    </div>
                                    <div class="col-sm-12">
                                        <label for="notes">Notes</label>
                                        {!! Form::textarea('notes', \request("notes"), ['class'=>'form-control', 'rows' => 2]) !!}


                                        {!! Form::submit(trans("content.submit"), ['class' => 'btn btn-success btn-sm btn-same-width']) !!}<br/>
    {{--                                        {!! Form::submit(trans("content.decline"), ['name' => 'decline', 'class' => 'btn btn-danger btn-sm btn-same-width']) !!}<br/>--}}
    {{--                                        {!! Form::submit(trans("content.change"),  ['name' => 'change', 'class' => 'btn btn-warning btn-sm btn-same-width']) !!}--}}
                                    </div>
                                {!! Form::close() !!}
                            </div>
                        @endif
                    </td>
                @endif
            </tr>


        @endforeach
    </tbody>
</table>


