@php $disabled = isset($disabled) ? 'disabled' : '' @endphp
@php $departments = isset($departments) ? $departments : [] @endphp
@php $first_name = isset($first_name) ? $first_name : null @endphp
@php $last_name = isset($last_name) ? $last_name : null @endphp
@php $email = isset($email) ? $email : null @endphp
@php $department = isset($department) ? $department : null @endphp
@php $postUrl = isset($postUrl) ? $postUrl : route("homepage")."#". url('user') @endphp

{!! Form::open(['method' => 'POST', 'class' => 'form-horizontal', 'url' => $postUrl ]) !!}

    <div class="form-group has-feedback col-md-12">
        <label class="control-label col-sm-3 list">@lang("content.first_name")</label>

        <div class="col-sm-9">
            {!! Form::text('first_name',$first_name, ['class'=>'form-control', 'placeholder'=>'First Name', 'id'=>'first_name' , 'required' => 'required', $disabled ]) !!}
            <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
        </div>
    </div>

    <div class="form-group has-feedback col-md-12">
        <label class="control-label col-sm-3 list">@lang("content.last_name")</label>

        <div class="col-sm-9">
            {!! Form::text('last_name', $last_name, ['class'=>'form-control', 'placeholder'=>'Last Name', 'id'=>'last_name' , 'required' => 'required', $disabled]) !!}
            <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
        </div>
    </div>
    <div class="form-group has-feedback col-md-12">
        <label class="control-label col-sm-3 list text-left">@lang("content.email")</label>

        <div class="col-sm-9">
            {!! Form::email('email', $email, ['class'=>'form-control', 'placeholder'=>'Email', 'id'=>'email', $disabled]) !!}
            <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
        </div>
    </div>


    <div class="form-group has-feedback col-md-12">
        <label class="control-label col-sm-3 list text-left">Password*</label>
        <div class="col-sm-9">
            {!! Form::password('password', array('class'=>'input-block-level form-control', 'placeholder'=>'Password', $disabled)) !!}
        </div>
    </div>
    <div class="form-group has-feedback col-md-12">
        <label class="control-label col-sm-3 list text-left">Password Confirmation</label>
        <div class="col-sm-9">
            {!! Form::password('password_confirmation', array('class'=>'input-block-level form-control','placeholder'=>'Confirm Password', $disabled)) !!}
        </div>
    </div>

    <div class="col-md-12">
        <label class="col-sm-12" style="padding: 0">(*) Password will be generated automatically if field is empty</label>
    </div>

    <div class="col-md-12">
        <hr/>
    </div>

    <div class="form-group col-md-12 list-header">
        <div class="col-sm-3 list">@lang("content.department")</div>
        <div class="col-sm-3">
            {!! Form::select('structure_department_id', $departments, $department, ['id' => 'structure_department_id', 'class' => 'form-control singleselect', 'required' => 'required', $disabled]) !!}
        </div>
    </div>
    @if (isset($position))
        <div class="form-group col-md-12 list-header">
            <div class="col-sm-3 list">@lang("content.position")</div>
            <div class="col-sm-3">
                {!! Form::select('structure_position_id', $positions, $position, ['class' => 'form-control singleselect', $disabled]) !!}
            </div>
        </div>
    @endif

    <div class="col-md-12">
        <hr/>
    </div>

    @if (!$disabled)
        <div class="form-group col-md-11 text-left" style="margin: 10px 0 0 5px">
            <a href="javascript:history.back()" class="btn btn-success {{ $disabled }}">Back</a>
            {!! Form::submit($submitLabel, array('class'=>'btn btn-primary', $disabled))!!}
        </div>
    @endif

    <div class="col-md-12">
    </div>
{!! Form::close() !!}