<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            @include('general.tab-header', ['departmentName' => 'User', 'moduleName' => 'Edit'])

            <div>
                {{--Upload Photo Form--}}
                <div class="col-sm-4">
                    @include('forms/general/upload-picture', ['postUrl' => url("user/upload/{$userId}")])
                </div>

                <div class="col-sm-6">

                    {!! Form::open(['method' => 'POST', 'class' => 'form-horizontal', 'url' => url("user/{$userId}") ]) !!}

                    <div class="tabbable">

                        {{--Tabs--}}
                        <ul class="nav nav-pills" id="myTab">
                            <li class="active">
                                <a href="#general" data-toggle="tab">@lang("content.general")</a>
                            </li>
                            <li>
                                <a href="#details" data-toggle="tab">@lang("content.details")</a>
                            </li>
                        </ul>

                        {{--Tab Content--}}
                        <div class="tab-content">
                            {{--General Tab--}}
                            <div class="tab-pane active" id="general">
                                @include('user/layouts/form-general', ['edit' => true])
                            </div>
                            {{--Details Tab--}}
                            <div class="tab-pane" id="details">
                                @include('user/layouts/form-details', ['edit' => true])
                            </div>
                        </div>
                    </div>

                    @php $authUser = \Auth::user() @endphp

                    {{--Form Submit--}}
                    <div class="form-group col-md-11 text-left" style="margin: 10px 0 0 5px">
                        <a href="javascript:history.back()" class="btn btn-success">Back</a>
                        @if ( in_array($authUser->user_role_id, [ROLE_DEPARTMENT_ADMIN, ROLE_ADMIN, ROLE_SUPER_ADMIN]) )
                            <a href="{{ url("organization")."?structure_department_id={$department}" }}" class="btn btn-primary">Organization</a>
                        @endif
                        {!! Form::submit('Save Changes', array('class'=>'btn btn-warning'))!!}
                    </div>

                    {!! Form::close() !!}
                </div>
            </div>

        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");

    };

    loadScript("{{ asset('/assets/js/views/user/edit.js') }}", pagefunction);


</script>


    {{--Image Upload And Cropper--}}
    {{--<script src="{{ asset('/assets/cropper/jquery.min.js') }}"></script>--}}
    {{--<script src="{{ asset('/assets/cropper/bootstrap.min.js') }}"></script>--}}
    {{--<script src="{{ asset('/assets/cropper/cropper.min.js') }}"></script>--}}
    {{--<script src="{{ asset('/assets/cropper/cropper-main.js') }}"></script>--}}
    {{--<script src="{{ asset("/packages/bootstrap/bootstrap.min.js") }}"></script>--}}
    {{----------------------------}}

