@php $future = strtotime($each->pReportTime) > strtotime(date("Y-m-d H:i:s")) @endphp
@php $class = $future  ? "disabled-items" : "modal-action-btn" @endphp

@if ($each->serviceType == DEPARTURE_SERVICE)
    @php $depArrType = "<span class='label label-primary font-sm'>DEPARTURE</span>" @endphp
    @php $depArr = $each->departure @endphp
@elseif ($each->serviceType == ARRIVAL_SERVICE)
    @php $depArrType = "<span class='label label-success font-sm'>ARRIVAL</span>" @endphp
    @php $depArr = $each->arrival @endphp
@elseif ($each->serviceType == TURNAROUND_SERVICE)
    @php $depArrType = "<span class='label label-warning font-sm'>TURNAROUND</span>" @endphp
    @php $depArr = $each->arrival @endphp
@endif

<tr class="{{ $future  ? "disabled-items" : "" }}" data-flight_staff_id="{{ $each->id }}"
data-planned_report_time="{{ date("Y-m-d H:i", strtotime($each->pReportTime)) }}" data-report_time="{{ $each->reportTime ? date("Y-m-d H:i", strtotime($each->reportTime)) : null }}"
data-planned_release_time="{{ date("Y-m-d H:i", strtotime($each->pReleaseTime)) }}" data-release_time="{{ $each->releaseTime ? date("Y-m-d H:i", strtotime($each->releaseTime)) : null }}"
data-flight_no="{{ $each->flightInfo }}" data-sector="{{ $each->route }}" data-sla="{{ $each->service->abbr }}" data-reason="{{ $each->reason }}"
>
    <td data-center>{{ $counter }}</td>
    <td>
        <p><a target="_blank" href="{{ url("flight-tracker/{$each->flight->id}") }}"><strong>{{ $each->flightInfo }} ({{ $each->route }})</strong></a></p>
        <p class="margin-bottom-0">{!! $depArrType !!} {!! baseDateFormat($depArr, true) !!}</p>
    </td>
    <td class="font-weight-bold" data-text-orange>{{ $each->service->abbr }}</td>
    <td>{!! $each->pReportTime ? $each->pReportTime : "-" !!}</td>
    <td>{!! $each->reportTime ? $each->reportTime : "-" !!}</td>
    <td>{!! $each->pReleaseTime ? $each->pReleaseTime : "-" !!}
    <td>{!! $each->releaseTime ? $each->releaseTime : "-" !!}</td>
    <td class="color-red">{{ $each->reason }}</td>
    <td>
        <button class='btn bg-yellow color-red font-sm font-weight-bold {{ $class }}' {!! !$future ? 'data-toggle="modal" data-target="#sla_modal"' : "" !!}>Input Actuals</button>
    </td>
{{--                            <td>{!! $each->pDurationTime && $each->pDurationTime != EMPTY_TIME_HM ? $each->pDurationTime : "-" !!}</td>--}}
{{--                            <td>{!! $each->durationTime && $each->durationTime != EMPTY_TIME_HM ? $each->durationTime : "-" !!}</td>--}}
</tr>
