@php $future = strtotime($each->pReportTime) > strtotime(date("Y-m-d H:i:s")) @endphp
@php $class = $future  ? "disabled-items" : "modal-action-btn" @endphp

@if ($each->serviceType == DEPARTURE_SERVICE)
    @php $depArrType = "<span class='label label-primary font-sm'>DEPARTURE</span>" @endphp
    @php $depArr = $each->departure @endphp
@elseif ($each->serviceType == ARRIVAL_SERVICE)
    @php $depArrType = "<span class='label label-success font-sm'>ARRIVAL</span>" @endphp
    @php $depArr = $each->arrival @endphp
@elseif ($each->serviceType == TURNAROUND_SERVICE)
    @php $depArrType = "<span class='label label-warning font-sm'>TURNAROUND</span>" @endphp
    @php $depArr = $each->arrival @endphp
@endif

<tr class="{{ $future  ? "disabled-items" : "" }}" data-flight_staff_id="{{ $each->id }}"
    data-planned_report_time="{{ date("Y-m-d H:i", strtotime($each->pReportTime)) }}" data-report_time="{{ $each->reportTime ? date("Y-m-d H:i", strtotime($each->reportTime)) : null }}"
    data-planned_release_time="{{ date("Y-m-d H:i", strtotime($each->pReleaseTime)) }}" data-release_time="{{ $each->releaseTime ? date("Y-m-d H:i", strtotime($each->releaseTime)) : null }}"
    data-flight_no="{{ $each->flightInfo }}" data-sector="{{ $each->route }}" data-sla="{{ $each->service->abbr }}" data-reason="{{ $each->reason }}">
    {{--                            <td data-center>{{ $i + 1 }}</td>--}}
    <td>
        <p>
            <a target="_blank" href="{{ url("flight-tracker/{$each->flight->id}") }}">
                <strong>{{ $each->flightInfo }}</strong> ({{ /* @var App\Classes\Staff\Flight\StaffFlight $each */ $each->route }})
            </a>
        </p>
        <p>{!! $depArrType !!}</p>
        <p class="margin-bottom-0">{!! baseDateFormat($depArr, true) !!}</p>
    </td>

    <td class="text-center">
        <p class="margin-bottom-0">{!! $each->pReportTime ? baseDateFormat($each->pReportTime, true) : "-" !!}</p>
        <p class="margin-bottom-5">{!! $each->pReleaseTime ? baseDateFormat($each->pReleaseTime, true) : "-" !!}</p>
        <p><span class='label label-warning font-sm'>{{ $each->service->abbr }}</span></p>
{{--                                <p class="margin-bottom-0" style="font-weight: bold">{!! $each->pDurationTime && $each->pDurationTime != EMPTY_TIME_HM ? "Duration: ".$each->pDurationTime : "-" !!}</p>--}}
    </td>

    <td class="text-center">
        <p class="margin-bottom-0">{!! $each->reportTime ? baseDateFormat($each->reportTime, true) : "-" !!}</p>
        <p class="margin-bottom-5">{!! $each->releaseTime ? baseDateFormat($each->releaseTime, true) : "-" !!}</p>
        <button class='btn bg-yellow color-red font-sm font-weight-bold {{ $class }}' {!! !$future ? 'data-toggle="modal" data-target="#sla_modal"' : "" !!}>Input Actuals</button>
{{--                                <p class="margin-bottom-0" style="font-weight: bold"> {!! $each->durationTime && $each->durationTime != EMPTY_TIME_HM ? "Duration: ".$each->durationTime : "-" !!}</p>--}}
    </td>
</tr>