<script>
    $(document).on("click", '.view_btn', function() {
        var _this = $(this);
        _this.parents("tr").find(".read_and_sign").removeAttr("disabled");
        // $('#read_and_sign').val(this.checked);
    });

    $(document).on("change", '.read_and_sign', function() {
        if(this.checked) {
            $(this).parent().next().removeAttr("disabled");
        }
        else {
            $(this).parent().next().attr("disabled", true);
        }
        // $('#read_and_sign').val(this.checked);
    });
</script>

@if (!count($libraryViews))
    <div class="alert alert-danger">
        You currently have no new notifications
    </div>
@else
<div class="jarviswidget jarviswidget-color-blueDark" id="email-recipient-list" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>

        <h2>@lang("content.list")</h2>
    </header>

    <!-- widget div-->
    <div>

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding" style="min-height: 50px !important;">

            <div class="table-responsive">

                <table class="table table-bordered table-hover apply_filter" id="notificationsTable">
                    <thead>
                    <tr>
                        <th>No</th>
                        <th>@lang("content.name")</th>
                        <th>@lang("content.airline")</th>
                        <th>@lang("content.created")</th>
                        <th>@lang("content.last_viewed")</th>
                        @if ($user->id == $authUser->id)
                            <th>@lang("content.actions")</th>
                            <th>@lang("content.viewed_and_signed")</th>
                            <th></th>
                        @else
                            <th>@lang("content.viewed_and_signed")</th>
                        @endif
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($libraryViews as $i => $each)
                        @if ($each->airlineLibrary)
                            @php $column = "airline-library" @endphp
                            @php $library = $each->airlineLibrary @endphp
                        @else
                            @php $column = "library" @endphp
                            @php $library = $each->library @endphp
                        @endif

                        @if ($library->deleted_at)
                            @continue
                        @endif

                        <tr class="{{ !$each->viewed_at ? "unread" : (!$each->signed_at ? "unsigned" : "") }}">
                            <td>{{ $i + 1 }}</td>
                            <td>
                                <a target="_blank" href="{{ url("{$column}/file/{$library->id}") }}?view=1" class="view_btn">
                                    {{ $library->name }}
                                </a>
                            </td>
                            <td>{{ $library->airline ? $library->airline->airline : "" }}</td>
                            <td>{{ $each->created_at }}</td>
                            <td>
                                @if ($each->viewed_at)
                                    <p class="color-green"><i class="fa fa-check font-md margin-right-5"></i> {{ $each->viewed_at }}</p>
                                @else
                                    <div class="text-center"><i class="fa fa-remove color-red font-md"></i></div>
                                @endif
                            </td>

                            @if ($user->id == $authUser->id)
                                @if ($library->attachment_file)
                                    <td style="min-width: 150px">
                                        <div class="btn-group">
                                            <a target="_blank" href="{{ url("{$column}/file/{$library->id}") }}?view=1" class="btn btn-warning view_btn">@lang("content.view")</a>
                                            <a href="{{ url("{$column}/file/{$library->id}") }}?download=1" class="btn btn-primary view_btn">@lang("content.download")</a>
                                        </div>
                                    </td>
                                @else
                                    <td class="color-red">Attachment document has not been uploaded yet.</td>
                                @endif

                                <td>
                                    @if ($each->signed_at)
                                        <p class="color-green"><i class="fa fa-check font-md margin-right-5"></i> {{ $each->signed_at }}</p>
                                    @else
                                        <div class="text-center"><i class="fa fa-remove color-red font-md"></i></div>
                                    @endif
                                </td>

                                <td>
                                    @if ($library->attachment_file)
                                        @if ($each->signed_at)
                                            <p class="color-green">
                                                <i class="fa fa-check font-md margin-right-5"></i>
                                                You have read and signed the document.
                                            </p>
                                        @else
                                            @php $viewed = $each->viewed_at || $each->downloaded_at @endphp
                                            @php $disabled = !$viewed ? "disabled" : "" @endphp
                                            @if (!$viewed)
                                                <p class="color-red">Please view or download the document and then sign it.</p>
                                            @endif

                                            <div class="form-inline">
                                                {!! Form::open(["url" => url("library-view/save/{$each->id}")]) !!}
                                                    <label class="margin-right-10">
                                                        {!! Form::checkbox("read_and_sign", 1, false, ["class" => "form-control margin-right-5 read_and_sign", $disabled]) !!}
                                                        Check here to indicate that you have read and signed the document
                                                    </label>
                                                    {!! Form::submit("Confirm", ["class" => "btn btn-success", "disabled"] ) !!}
                                                {!! Form::close() !!}
                                            </div>
                                        @endif
                                    @endif
                                </td>
                            @else
                                <td>
                                    @if ($each->signed_at)
                                        <p class="color-green"><i class="fa fa-check font-md margin-right-5"></i> {{ $each->signed_at }}</p>
                                    @else
                                        <div class="text-center"><i class="fa fa-remove color-red font-md"></i></div>
                                    @endif
                                </td>
                            @endif
                        </tr>
                    @endforeach
                    </tbody>
                </table>

            </div>

        </div>

    </div>

</div>
@endif