<!-- Widget ID (each widget will need unique ID)-->
<div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-transfer" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
<!-- widget options:
usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

data-widget-colorbutton="false"
data-widget-editbutton="false"
data-widget-togglebutton="false"
data-widget-deletebutton="false"
data-widget-fullscreenbutton="false"
data-widget-custombutton="false"
data-widget-collapsed="true"
data-widget-sortable="false"

-->
<header>

    <span class="widget-icon"> <i class="fa fa-table"></i> </span>

    <h2>@lang("content.list")</h2>

</header>

<!-- widget div-->
<div>

    <!-- widget edit box -->
    <div class="jarviswidget-editbox">
        <!-- This area used as dropdown edit box -->

    </div>
    <!-- end widget edit box -->

    <!-- widget content -->
    <div class="widget-body no-padding">

        <div class="table-responsive" style="overflow: auto;">

            @if (isset($data) && count($data))

                <table class="table table-bordered table-hover" id="passenger-report-table" style="min-width: 100%">

                    <thead>
                        <tr>
                            <th rowspan="2">No</th>
                            <th colspan="4">@lang("content.flight_details")</th>
                            <th colspan="4">@lang("content.container_details")</th>

                            <th rowspan="2">CPT</th>
                            <th rowspan="2">@lang("content.position")</th>
                            <th rowspan="2">@lang("content.weight"), KGs</th>
                            <th rowspan="2">@lang("content.content")</th>
                            <th rowspan="2">VR</th>
                        </tr>

                        <tr>
                            <th>@lang("content.status")</th>
                            <th>@lang("content.flight_number")</th>
                            <th style="min-width: 60px;">@lang("content.sector")</th>
                            <th style="min-width: 60px;">@lang("content.date")</th>

                            <th>ID</th>
                            <th>@lang("content.type")</th>
                            <th>@lang("content.owner")</th>
                            <th>@lang("content.status")</th>
                        </tr>
                    </thead>

                    <tbody>
                    @php $j = 0 @endphp
                    @foreach($data as $each)

                        @php $info = $each->info @endphp
                        @php $flight = $info ? $info->flight : null @endphp
                        @php $flightNumber = $flight ? $flight->flightNumber : null @endphp
                        @php $depAirport = $flightNumber ? $flightNumber->departureAirport : null @endphp
                        @php $arrAirport = $flightNumber ? $flightNumber->arrivalAirport : null @endphp
                        @php $airline = $flightNumber ? $flightNumber->airline : null @endphp

                        @php $fltNo  = ($airline ? getAirlineCode($airline) : "").($flightNumber ? $flightNumber->flight_number : "-") @endphp
                        @php $sector = ($depAirport ? $depAirport->iata : "")."-".($arrAirport ? $arrAirport->iata : "") @endphp

                        @php $container = $each->container @endphp
                        @php $type = $container ? $container->type : null @endphp
                        @php $containerID = $container ? ($type ? $type->name : "").$container->num.$container->owner : "-" @endphp

                        @php $status = getFlightsDepArrType($flight, $handlingStations) @endphp
                        <tr class="{{ $j == 0 ? "bg-color-orange color-white" : ""}}">
                            <td>{{ ++$j }}</td>
                            <td>{!! $status == ARRIVAL ? '<i class="fa fa-arrow-right color-green"></i> IN' : 'OUT <i class="fa fa-arrow-right color-red"></i>' !!}</td>
                            <td>{{ $fltNo }}</td>
                            <td>{{ $sector }}</td>
                            <td>{{ $flight ? baseDateFormat(getFlightDepartureDate($flight)) : "-" }}</td>

                            <td>{{ $containerID }}</td>
                            <td>{{ $type ? $type->name : "-" }}</td>
                            <td>{{ $container ? $container->owner : "-" }}</td>
                            <td data-center>{!! $each->container_matched ? '<span class="label label-primary font-sm">Matched</span>' : "" !!}</td>

                            <td>{{ $each->row_number ? substr($each->row_number, 0, 1) : "-" }}</td>
                            <td>{{ $each->row_number.$each->position }}</td>
                            <td>{{ $each->weight }}</td>
                            <td>{{ $each->loaded_type }}</td>
                            <td>{{ $each->vr }}</td>
                        </tr>

                    @endforeach
                    </tbody>

                </table>

            @endif

        </div>

    </div>

</div>

</div>
