<!-- Widget ID (each widget will need unique ID)-->
<div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-table" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
<!-- widget options:
usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

data-widget-colorbutton="false"
data-widget-editbutton="false"
data-widget-togglebutton="false"
data-widget-deletebutton="false"
data-widget-fullscreenbutton="false"
data-widget-custombutton="false"
data-widget-collapsed="true"
data-widget-sortable="false"

-->
<header>

    <span class="widget-icon"> <i class="fa fa-table"></i> </span>

    <h2>@lang("content.list")</h2>

</header>

<!-- widget div-->
<div>

    <!-- widget edit box -->
    <div class="jarviswidget-editbox">
        <!-- This area used as dropdown edit box -->

    </div>
    <!-- end widget edit box -->

    <!-- widget content -->
    <div class="widget-body no-padding">

        <div class="table-responsive">

            @if (isset($data) && count($data))

                <table class="table table-bordered table-hover" id="uld-table" style="min-width: 100%">

                    <thead>
                        <tr>
                            <th rowspan="2">No</th>
                            <th colspan="4">@lang("content.flight_details")</th>
                            <th colspan="3">@lang("content.container_details")</th>
                        </tr>

                        <tr>
                            <th>@lang("content.status")</th>
                            <th>@lang("content.flight_number")</th>
                            <th>@lang("content.sector")</th>
                            <th>@lang("content.date")</th>

                            <th>ID</th>
                            <th>@lang("content.type")</th>
                            <th>@lang("content.owner")</th>
                        </tr>
                    </thead>

                    <tbody>
                    @php $j = 0 @endphp
                    @foreach($data as $each)

                        @php $flight = $each->flight @endphp
                        @php $flightNumber = $flight ? $flight->flightNumber : null @endphp
                        @php $depAirport = $flightNumber ? $flightNumber->departureAirport : null @endphp
                        @php $arrAirport = $flightNumber ? $flightNumber->arrivalAirport : null @endphp
                        @php $airline = $flightNumber ? $flightNumber->airline : null @endphp

                        @php $fltNo  = ($airline ? getAirlineCode($airline) : "").($flightNumber ? $flightNumber->flight_number : "-") @endphp
                        @php $sector = ($depAirport ? $depAirport->iata : "")."-".($arrAirport ? $arrAirport->iata : "") @endphp

                        @foreach($each->flightContainer as $flightContainer)
                            @php $container = $flightContainer->container @endphp
                            @php $type = $container ? $container->type : null @endphp
                            @php $containerID = $container ? ($type ? $type->name : "").$container->num.$container->owner : "-" @endphp
                            @php $status = getFlightsDepArrType($flight, $handlingStations) @endphp
                            <tr>
                                <td>{{ ++$j }}</td>

                                <td>{!! $status == ARRIVAL ? '<i class="fa fa-arrow-right color-green"></i> IN' : 'OUT <i class="fa fa-arrow-right color-red"></i>' !!}</td>
                                <td>{{ $fltNo }}</td>
                                <td>{{ $sector }}</td>
                                <td>{{ $flight ? baseDateFormat(getFlightDepartureDate($flight)) : "-" }}</td>

                                <td>
                                    @if ($container)
                                        <a target="_blank" href="{{ route("homepage")."#uld-report/{$container->id}?dateSearch=all" }}">{{ $containerID }}</a>
                                    @else
                                        {{ $containerID }}
                                    @endif
                                </td>

                                <td>{{ $type ? $type->name : "-" }}</td>
                                <td>{{ $container ? $container->owner : "-" }}</td>
                            </tr>
                        @endforeach

                    @endforeach
                    </tbody>

                </table>

            @endif

        </div>

    </div>

</div>

</div>
