<!-- Widget ID (each widget will need unique ID)-->
<div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-stock" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
<!-- widget options:
usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

data-widget-colorbutton="false"
data-widget-editbutton="false"
data-widget-togglebutton="false"
data-widget-deletebutton="false"
data-widget-fullscreenbutton="false"
data-widget-custombutton="false"
data-widget-collapsed="true"
data-widget-sortable="false"

-->
<header>

    <span class="widget-icon"> <i class="fa fa-table"></i> </span>

    <h2>@lang("content.stock")</h2>

</header>

<!-- widget div-->
<div>

    <!-- widget edit box -->
    <div class="jarviswidget-editbox">
        <!-- This area used as dropdown edit box -->

    </div>
    <!-- end widget edit box -->

    <!-- widget content -->
    <div class="widget-body no-padding">

        <div class="table-responsive">

            @if (isset($stockULDs) && count($stockULDs))

                <table class="table table-bordered table-hover" id="stock-table" style="min-width: 100%">

                    <thead>
                        <tr>
                            <th>No</th>
                            <th>ID</th>
                            <th>@lang("content.type")</th>
                            <th>@lang("content.owner")</th>
                        </tr>

                    </thead>

                    <tbody>
                    @foreach($stockULDs as $j => $uld)

                        @php $container = $uld->container @endphp
                        @php $type = $container->type @endphp
                        @php $containerID = $container ? ($type ? $type->name : "").$container->num.$container->owner : "-" @endphp

                        <tr>
                            <td>{{ $j + 1 }}</td>

                            <td>
                                @if ($container)
                                    <a target="_blank" href="{{ route("homepage")."#uld-report/{$container->id}?dateSearch=all" }}">{{ $containerID }}</a>
                                @else
                                    {{ $containerID }}
                                @endif
                            </td>

                            <td>{{ $type ? $type->name : "-" }}</td>
                            <td>{{ $container ? $container->owner : "-" }}</td>

                        </tr>

                    @endforeach
                    </tbody>

                </table>

            @endif

        </div>

    </div>

</div>

</div>
